/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public final class Optionals {
    private Optionals() {
        throw new UnsupportedOperationException("Not for instantiation");
    }

    @Nonnull
    public static <T> Optional<T> fallBack(Optional<T> primary, Supplier<Optional<T>> secondarySupplier) {
        if (primary.isPresent()) {
            return primary;
        }
        return secondarySupplier.get();
    }

    public static <T> void foldToEffect(Optional<T> optional, Consumer<T> ifPresent, Runnable ifAbsent) {
        if (optional.isPresent()) {
            ifPresent.accept(optional.get());
        } else {
            ifAbsent.run();
        }
    }
}

