/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.Function;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class SplitStreamHelper {
    private SplitStreamHelper() {
    }

    public static <T> Stream<T> streamWithSplitIterator(final Function<Optional<T>, List<T>> query, final int batchSize) {
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 1024){
            T lastItem;
            Spliterator<T> batch;
            boolean lastBatch;
            {
                super(x0, x1);
                this.lastItem = null;
                this.batch = Spliterators.emptySpliterator();
                this.lastBatch = false;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                boolean advanced = this.batch.tryAdvance(action);
                if (!advanced && !this.lastBatch) {
                    List items = (List)query.apply(Optional.ofNullable(this.lastItem));
                    if (!items.isEmpty()) {
                        this.lastItem = items.get(items.size() - 1);
                    }
                    if (items.size() < batchSize) {
                        this.lastBatch = true;
                    }
                    this.batch = items.spliterator();
                    return this.batch.tryAdvance(action);
                }
                return advanced;
            }
        }, false);
    }
}

