/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import java.net.IDN;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.commons.validator.routines.RegexValidator;

public final class UrlValidator {
    private static org.apache.commons.validator.routines.UrlValidator urlValidator;

    public static boolean isValid(String url) {
        if (url == null) {
            return false;
        }
        try {
            URI uri = new URI(url);
            String authority = uri.getAuthority();
            if (authority == null) {
                return false;
            }
            try {
                authority = IDN.toASCII(authority);
            }
            catch (IllegalArgumentException ex) {
                return false;
            }
            url = new URI(uri.getScheme(), authority, uri.getPath(), null, null).toString();
            return urlValidator.isValid(url);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    static {
        String[] schemes = new String[]{"http", "https"};
        urlValidator = new MyValidator(schemes);
    }

    private static class MyValidator
    extends org.apache.commons.validator.routines.UrlValidator {
        private static final String AUTHORITY_REGEX = "(?:\\[([0-9a-fA-F:]+)\\]|(?:(?:[a-zA-Z0-9%-._~!$&'()*+,;=]+(?::[a-zA-Z0-9%-._~!$&'()*+,;=]*)?@)?([\\p{Alnum}\\-\\.]*)))(?::(\\d*))?(.*)?";
        private static final Pattern AUTHORITY_PATTERN = Pattern.compile("(?:\\[([0-9a-fA-F:]+)\\]|(?:(?:[a-zA-Z0-9%-._~!$&'()*+,;=]+(?::[a-zA-Z0-9%-._~!$&'()*+,;=]*)?@)?([\\p{Alnum}\\-\\.]*)))(?::(\\d*))?(.*)?");
        private static final int PARSE_AUTHORITY_IPV6 = 1;
        private static final int PARSE_AUTHORITY_HOST_IP = 2;
        private static final int PARSE_AUTHORITY_PORT = 3;
        private static final int PARSE_AUTHORITY_EXTRA = 4;
        private static final String DOMAIN_LABEL_REGEX = "\\p{Alnum}(?>[\\p{Alnum}-]*\\p{Alnum})*";
        private static final String TOP_LABEL_REGEX = "\\p{Alnum}{2,}";
        private static final String DOMAIN_NAME_REGEX = "^(?:\\p{Alnum}(?>[\\p{Alnum}-]*\\p{Alnum})*\\.)+(\\p{Alnum}{2,})$";
        private final RegexValidator domainRegex = new RegexValidator("^(?:\\p{Alnum}(?>[\\p{Alnum}-]*\\p{Alnum})*\\.)+(\\p{Alnum}{2,})$");
        private final RegexValidator hostnameRegex = new RegexValidator("\\p{Alnum}(?>[\\p{Alnum}-]*\\p{Alnum})*");

        public MyValidator(String[] schemes) {
            super(schemes);
        }

        private boolean isValidDomain(String domain) {
            String[] groups = this.domainRegex.match(domain);
            if (groups != null && groups.length > 0) {
                return true;
            }
            return this.hostnameRegex.isValid(domain);
        }

        protected boolean isValidAuthority(String authority) {
            InetAddressValidator inetAddressValidator;
            if (authority == null) {
                return false;
            }
            Matcher authorityMatcher = AUTHORITY_PATTERN.matcher(authority);
            if (!authorityMatcher.matches()) {
                return false;
            }
            String ipv6 = authorityMatcher.group(1);
            if (ipv6 != null) {
                InetAddressValidator inetAddressValidator2 = InetAddressValidator.getInstance();
                return inetAddressValidator2.isValidInet6Address(ipv6);
            }
            String hostLocation = authorityMatcher.group(2);
            if (!this.isValidDomain(hostLocation) && !(inetAddressValidator = InetAddressValidator.getInstance()).isValid(hostLocation)) {
                return false;
            }
            String port = authorityMatcher.group(3);
            if (StringUtils.isNotEmpty((CharSequence)port)) {
                try {
                    int iPort = Integer.parseInt(port);
                    if (iPort < 0 || iPort > 65535) {
                        return false;
                    }
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            String extra = authorityMatcher.group(4);
            return StringUtils.isBlank((CharSequence)extra);
        }
    }
}

