/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.compression.ArchiveUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtils {
    private static final Logger log = LoggerFactory.getLogger(ZipUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream streamForZipFileEntry(File zipFile, String entryName) throws IOException {
        final ZipFile file = new ZipFile(zipFile.getAbsolutePath());
        InputStream underlyingStream = null;
        try {
            ZipArchiveEntry entry = file.getEntry(entryName);
            if (entry == null) {
                InputStream inputStream = null;
                return inputStream;
            }
            underlyingStream = file.getInputStream(entry);
        }
        finally {
            if (underlyingStream == null) {
                ZipFile.closeQuietly((ZipFile)file);
            }
        }
        return new FilterInputStream(underlyingStream){

            @Override
            public void close() throws IOException {
                super.close();
                file.close();
            }
        };
    }

    public static void zip(File inputDir, File output) throws IOException {
        if (!inputDir.exists()) {
            throw new FileNotFoundException(inputDir.getPath());
        }
        if (!output.exists()) {
            output.createNewFile();
        } else {
            if (output.isDirectory()) {
                throw new IOException("'" + output.getPath() + "' exists and is a directory. Cannot overwrite.");
            }
            if (!output.canWrite()) {
                throw new IOException("'" + output.getPath() + "' exists and is not writable.");
            }
        }
        out.setLevel(-1);
        try (ZipArchiveOutputStream out = new ZipArchiveOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(output)));){
            ZipUtils.compressDirectory(inputDir, out, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compressDirectory(File inputDir, ZipArchiveOutputStream out, String parentPath) throws IOException {
        File[] files;
        for (File file : files = inputDir.listFiles()) {
            String name = parentPath + file.getName();
            ZipArchiveEntry archiveEntry = new ZipArchiveEntry(file, name);
            out.putArchiveEntry((ArchiveEntry)archiveEntry);
            if (file.isDirectory()) {
                ZipUtils.compressDirectory(file, out, archiveEntry.getName());
                continue;
            }
            FileInputStream input = new FileInputStream(file);
            try {
                IOUtils.copyLarge((InputStream)input, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
                out.closeArchiveEntry();
            }
        }
    }

    public static void unzip(File input, File outputDir) throws IOException {
        ArchiveUtils.decompress(input, ArchiveUtils.Type.ZIP, outputDir);
    }
}

