/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.Transformed;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

class CollectionMap<K>
extends AbstractMap<K, K> {
    private final Collection<? extends K> collection;

    public CollectionMap(Collection<? extends K> collection) {
        this.collection = collection;
    }

    @Override
    public Set<Map.Entry<K, K>> entrySet() {
        return new LinkedHashSet<Map.Entry<K, K>>(Transformed.collection(this.collection, (Function)new Function<K, Map.Entry<K, K>>(){

            public Map.Entry<K, K> apply(K input) {
                return new SimpleEntry(input);
            }
        }));
    }

    static class SimpleEntry<K>
    implements Map.Entry<K, K> {
        private final K value;

        SimpleEntry(K value) {
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.value;
        }

        @Override
        public K getValue() {
            return this.value;
        }

        @Override
        public K setValue(K value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return SimpleEntry.eq(this.value, e.getKey()) && SimpleEntry.eq(this.value, e.getValue());
        }

        @Override
        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode() ^ this.value.hashCode();
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }
}

