/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.compression;

import com.atlassian.jira.util.compression.AbstractArchiveCompressor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

class ZipArchiveCompressor
extends AbstractArchiveCompressor {
    ZipArchiveCompressor(File file) throws IOException {
        super(ZipArchiveCompressor.createArchiveOutputStream(file));
    }

    private static ArchiveOutputStream createArchiveOutputStream(File file) throws IOException {
        ZipArchiveOutputStream zipArchiveOutputStream = new ZipArchiveOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file)));
        zipArchiveOutputStream.setLevel(-1);
        return zipArchiveOutputStream;
    }

    @Override
    ArchiveEntry createArchiveEntry(File file, String name) {
        return new ZipArchiveEntry(file, name);
    }
}

