/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.log;

import com.atlassian.jira.logging.RollOverLogAppender;
import com.atlassian.jira.startup.FormattedLogMsg;
import java.io.File;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogMarker {
    private static final Logger log = LogManager.getLogger(LogMarker.class);

    public static void markLogs(String message) {
        FormattedLogMsg logMsg = new FormattedLogMsg(log);
        if (message != null && !message.isEmpty()) {
            logMsg.add(message);
        }
        logMsg.printMessage(Level.INFO, true);
    }

    public static void rolloverAndMark(String message) {
        LogMarker.markLogs("");
        LogMarker.rollover(log);
        LogMarker.markLogs(message);
    }

    public static void rollover(Logger log) {
        org.apache.logging.log4j.core.Logger logger;
        for (logger = (org.apache.logging.log4j.core.Logger)log; logger != null && logger.getAppenders().isEmpty(); logger = logger.getParent()) {
        }
        if (logger == null) {
            return;
        }
        logger.getAppenders().values().forEach(appender -> {
            if (appender instanceof RollOverLogAppender) {
                LogMarker.rolloverAsAppropriate((RollOverLogAppender)appender);
            }
        });
    }

    private static void rolloverAsAppropriate(RollOverLogAppender rollOverLogAppender) {
        File logFile = new File(rollOverLogAppender.getFile());
        if (logFile.exists() && logFile.length() > 0L) {
            rollOverLogAppender.rollOver();
        }
    }
}

