/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.mobile;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.util.mobile.MobileAppBanner;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IosMobileAppBanner
implements MobileAppBanner {
    private static final Logger log = LoggerFactory.getLogger(IosMobileAppBanner.class);
    private static final String JIRA_MOBILE_SCHEME = "jira-server://";
    private static final String IOS_APP_ID = "1405353949";
    private static final String OS_DESTINATION_HEADER = "os_destination";
    private static final Pattern HTTP_PROTOCOL_PATTERN = Pattern.compile("http://|https://");
    private static final Pattern ISSUE_MOBILE_URL_PATTERN = Pattern.compile(".*#issue/([A-Z0-9]+-[0-9]+).*");
    private static final Pattern ISSUE_DESKTOP_URL_PATTERN = Pattern.compile("^/browse/([A-Z0-9]+-[0-9]+).*");
    private static final String HTML_TEMPLATE = "<meta name=\"apple-itunes-app\" content=\"app-id=%s, app-argument=%s \">";
    private final HttpServletRequest request;

    public IosMobileAppBanner(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    @Nonnull
    public String getBannerHtml() {
        return String.format(HTML_TEMPLATE, IOS_APP_ID, this.getIosAppArgument());
    }

    private String getIosAppArgument() {
        try {
            String baseUrl = ComponentAccessor.getApplicationProperties().getString("jira.baseurl");
            String mobileAppSchemeUrl = HTTP_PROTOCOL_PATTERN.matcher(baseUrl).replaceFirst(JIRA_MOBILE_SCHEME) + "?source=login";
            String osDestination = this.request.getParameter(OS_DESTINATION_HEADER);
            Optional<String> issueKey = IosMobileAppBanner.extractIssueKey(osDestination);
            return issueKey.map(key -> mobileAppSchemeUrl + "&type=issue&value=" + (String)issueKey.get()).orElse(mobileAppSchemeUrl);
        }
        catch (Exception e) {
            log.warn("Cannot get ios app argument.");
            return JIRA_MOBILE_SCHEME;
        }
    }

    private static Optional<String> extractIssueKey(String osDestination) {
        if (StringUtils.isNotBlank((CharSequence)osDestination)) {
            Matcher matcher = ISSUE_MOBILE_URL_PATTERN.matcher(osDestination);
            if (matcher.matches()) {
                return Optional.ofNullable(matcher.group(1));
            }
            matcher = ISSUE_DESKTOP_URL_PATTERN.matcher(osDestination);
            if (matcher.matches()) {
                return Optional.ofNullable(matcher.group(1));
            }
        }
        return Optional.empty();
    }
}

