/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.resourcebundle;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.util.resourcebundle.DebuggingResourceBundle;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import io.atlassian.util.concurrent.CopyOnWriteMap;
import java.util.Locale;
import java.util.ResourceBundle;

public class DefaultResourceBundle {
    private static final CopyOnWriteMap<Locale, ResourceBundle> resourceBundleMap = CopyOnWriteMap.newHashMap();
    public static final String DEFAULT_RESOURCE_BUNDLE_NAME = JiraWebActionSupport.class.getName();

    public static ResourceBundle getDefaultResourceBundle(Locale locale) {
        ResourceBundle resourceBundle = (ResourceBundle)resourceBundleMap.get((Object)locale);
        if (resourceBundle == null) {
            ResourceBundle result;
            if (JiraSystemProperties.isI18nReloadBundles()) {
                resourceBundle = DebuggingResourceBundle.getDebuggingResourceBundle(DEFAULT_RESOURCE_BUNDLE_NAME, locale);
            }
            if (resourceBundle == null) {
                resourceBundle = ResourceBundle.getBundle(DEFAULT_RESOURCE_BUNDLE_NAME, locale);
            }
            return (result = (ResourceBundle)resourceBundleMap.putIfAbsent((Object)locale, (Object)resourceBundle)) == null ? resourceBundle : result;
        }
        return resourceBundle;
    }

    public static boolean isDefaultResourceBundleStale(Locale locale) {
        ResourceBundle resourceBundle = (ResourceBundle)resourceBundleMap.get((Object)locale);
        return resourceBundle instanceof DebuggingResourceBundle && ((DebuggingResourceBundle)resourceBundle).isStale();
    }
}

