/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.system.check;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.util.system.VersionNumber;
import com.atlassian.jira.util.system.check.I18nMessage;
import com.atlassian.jira.util.system.check.SystemEnvironmentCheck;
import com.atlassian.jira.web.ServletContextProvider;
import javax.servlet.ServletContext;

class JRA10145Check
implements SystemEnvironmentCheck {
    private static final String LIMIT_BUFFER = "org.apache.jasper.runtime.BodyContentImpl.LIMIT_BUFFER";
    final VersionNumber v5 = new VersionNumber("5.0");
    final VersionNumber v5_5_15 = new VersionNumber("5.5.15");
    private final JiraProperties jiraSystemProperties;

    public JRA10145Check(JiraProperties jiraSystemProperties) {
        this.jiraSystemProperties = jiraSystemProperties;
    }

    @Override
    public I18nMessage getWarningMessage() {
        ServletContext context = ServletContextProvider.getServletContext();
        String serverInfo = context.getServerInfo();
        if (serverInfo.indexOf("Tomcat") >= 0) {
            VersionNumber versionNumber = new VersionNumber(serverInfo.substring(serverInfo.indexOf("/") + 1));
            if (versionNumber.isLessThan(this.v5)) {
                return null;
            }
            if (versionNumber.isLessThan(this.v5_5_15)) {
                I18nMessage warning = new I18nMessage("admin.warning.tomcat.version");
                warning.addParameter(serverInfo);
                warning.addParameter(LIMIT_BUFFER);
                return warning;
            }
            if (!this.jiraSystemProperties.getBoolean(LIMIT_BUFFER).booleanValue()) {
                I18nMessage warning = new I18nMessage("admin.warning.tomcat.limitbuffer");
                warning.addParameter(serverInfo);
                warning.addParameter(LIMIT_BUFFER);
                return warning;
            }
        }
        return null;
    }
}

