/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.versioning;

import com.atlassian.jira.database.DatabaseUtil;
import com.atlassian.jira.index.ha.WithIdAndVersion;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.model.querydsl.CommentVersionDTO;
import com.atlassian.jira.model.querydsl.IssueVersionDTO;
import com.atlassian.jira.model.querydsl.WorklogVersionDTO;
import java.time.Instant;
import java.util.Objects;

public class EntityVersion
implements WithIdAndVersion {
    private final long id;
    private final long version;
    private final Instant dbUpdatedTime;
    private final boolean deleted;
    private final IndexDirectoryFactory.Name indexName;

    public String toString() {
        return "EntityVersion{id=" + this.id + ", version=" + this.version + ", dbUpdatedTime=" + this.dbUpdatedTime + ", deleted=" + this.deleted + ", indexName=" + (Object)((Object)this.indexName) + '}';
    }

    public EntityVersion(long id, long version, Instant dbUpdatedTime, boolean deleted, IndexDirectoryFactory.Name indexName) {
        this.id = id;
        this.version = version;
        this.dbUpdatedTime = dbUpdatedTime;
        this.deleted = deleted;
        this.indexName = indexName;
    }

    public EntityVersion(IssueVersionDTO dto) {
        this(dto.getIssueId(), dto.getIndexVersion(), dto.getUpdateTime().toInstant(), dto.getDeleted().equals(DatabaseUtil.booleanToChar1(true)), IndexDirectoryFactory.Name.ISSUE);
    }

    public EntityVersion(CommentVersionDTO dto) {
        this(dto.getCommentId(), dto.getIndexVersion(), dto.getUpdateTime().toInstant(), dto.getDeleted().equals(DatabaseUtil.booleanToChar1(true)), IndexDirectoryFactory.Name.COMMENT);
    }

    public EntityVersion(WorklogVersionDTO dto) {
        this(dto.getWorklogId(), dto.getIndexVersion(), dto.getUpdateTime().toInstant(), dto.getDeleted().equals(DatabaseUtil.booleanToChar1(true)), IndexDirectoryFactory.Name.WORKLOG);
    }

    public Long getId() {
        return this.id;
    }

    @Override
    public Long getVersion() {
        return this.version;
    }

    public Instant getDbUpdatedTime() {
        return this.dbUpdatedTime;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public IndexDirectoryFactory.Name getIndexName() {
        return this.indexName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityVersion that = (EntityVersion)o;
        return this.id == that.id && this.version == that.version && this.deleted == that.deleted && Objects.equals(this.dbUpdatedTime, that.dbUpdatedTime) && this.indexName == that.indexName;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.version, this.dbUpdatedTime, this.deleted, this.indexName});
    }
}

