/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.versioning;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.index.ManagedIndexSearcher;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.issue.index.InternalIndexingService;
import com.atlassian.jira.issue.statistics.util.FieldDocumentHitCollector;
import com.atlassian.jira.model.querydsl.CommentVersionDTO;
import com.atlassian.jira.model.querydsl.DTO;
import com.atlassian.jira.model.querydsl.IssueVersionDTO;
import com.atlassian.jira.model.querydsl.QCommentVersion;
import com.atlassian.jira.model.querydsl.QIssueVersion;
import com.atlassian.jira.model.querydsl.QWorklogVersion;
import com.atlassian.jira.model.querydsl.WorklogVersionDTO;
import com.atlassian.jira.transaction.TransactionSupport;
import com.atlassian.jira.versioning.EntityVersion;
import com.atlassian.jira.versioning.EntityVersioningManager;
import com.atlassian.jira.versioning.IncrementDeletedEntityVersionException;
import com.atlassian.jira.versioning.TransactionSupportHelper;
import com.atlassian.jira.versioning.VersioningDao;
import com.atlassian.jira.versioning.VersioningDaoFactory;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.BytesRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityVersioningManagerImpl
implements EntityVersioningManager {
    private static final Logger log = LoggerFactory.getLogger(EntityVersioningManagerImpl.class);
    private final VersioningDao<QIssueVersion, IssueVersionDTO> issueVersionDao;
    private final VersioningDao<QCommentVersion, CommentVersionDTO> commentVersionDao;
    private final VersioningDao<QWorklogVersion, WorklogVersionDTO> worklogVersionDao;
    private final TransactionSupportHelper transactionSupportHelper;

    public EntityVersioningManagerImpl(VersioningDaoFactory factory, TransactionSupport transactionSupport, EventPublisher eventPublisher) {
        this.issueVersionDao = factory.createIssueVersioningDao();
        this.commentVersionDao = factory.createCommentVersioningDao();
        this.worklogVersionDao = factory.createWorklogVersioningDao();
        this.transactionSupportHelper = new TransactionSupportHelper(transactionSupport);
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void onPluginFrameworkShutdownEvent(PluginFrameworkShutdownEvent event) {
        this.transactionSupportHelper.shutdown();
    }

    @Override
    public void incrementIssueVersion(long issueId) throws IncrementDeletedEntityVersionException {
        this.incrementVersion(this.issueVersionDao, issueId, null);
    }

    @Override
    public void incrementCommentVersion(long commentId, long parentIssueId) throws IncrementDeletedEntityVersionException {
        this.incrementVersion(this.commentVersionDao, commentId, parentIssueId);
    }

    @Override
    public void incrementWorklogVersion(long worklogId, long parentIssueId) throws IncrementDeletedEntityVersionException {
        this.incrementVersion(this.worklogVersionDao, worklogId, parentIssueId);
    }

    @Override
    public void incrementRelatedCommentVersions(long parentIssueId) {
        this.transactionSupportHelper.executeWithRequiredNew(() -> this.commentVersionDao.incrementEntityVersionsRelatedToIssue(parentIssueId));
    }

    @Override
    public void incrementRelatedWorklogVersions(long parentIssueId) {
        this.transactionSupportHelper.executeWithRequiredNew(() -> this.worklogVersionDao.incrementEntityVersionsRelatedToIssue(parentIssueId));
    }

    @Override
    public void markIssueDeletedAndIncrementVersion(long issueId) {
        this.markAsDeletedAndIncrementVersion(this.issueVersionDao, issueId);
        this.transactionSupportHelper.executeWithRequiredNew(() -> {
            this.commentVersionDao.markRelatedToIssueAsDeletedAndUpdateVersion(issueId);
            this.worklogVersionDao.markRelatedToIssueAsDeletedAndUpdateVersion(issueId);
            return null;
        });
    }

    @Override
    public void markCommentDeletedAndIncrementVersion(long commentId) {
        this.markAsDeletedAndIncrementVersion(this.commentVersionDao, commentId);
    }

    @Override
    public void markWorklogDeletedAndIncrementVersion(long worklogId) {
        this.markAsDeletedAndIncrementVersion(this.worklogVersionDao, worklogId);
    }

    @Override
    public Optional<Long> getIssueVersion(long issueId) {
        return this.transactionSupportHelper.execute(() -> this.issueVersionDao.getCurrentVersion(issueId));
    }

    @Override
    public Optional<EntityVersion> getIssueEntityVersion(long issueId) {
        return this.transactionSupportHelper.execute(() -> this.issueVersionDao.getCurrentEntityVersion(issueId).map(EntityVersion::new));
    }

    @Override
    public Optional<Long> getCommentVersion(long commentId) {
        return this.transactionSupportHelper.execute(() -> this.commentVersionDao.getCurrentVersion(commentId));
    }

    @Override
    public Optional<EntityVersion> getCommentEntityVersion(long commentId) {
        return this.transactionSupportHelper.execute(() -> this.commentVersionDao.getCurrentEntityVersion(commentId).map(EntityVersion::new));
    }

    @Override
    public Optional<Long> getWorklogVersion(long worklogId) {
        return this.transactionSupportHelper.execute(() -> this.worklogVersionDao.getCurrentVersion(worklogId));
    }

    @Override
    public Optional<EntityVersion> getWorklogEntityVersion(long worklogId) {
        return this.transactionSupportHelper.execute(() -> this.worklogVersionDao.getCurrentEntityVersion(worklogId).map(EntityVersion::new));
    }

    @Override
    public Map<Long, Long> getRelatedCommentVersions(long parentIssueId) {
        return this.transactionSupportHelper.execute(() -> this.commentVersionDao.getEntityVersionsRelatedToIssue(parentIssueId).stream().collect(Collectors.toMap(CommentVersionDTO::getCommentId, CommentVersionDTO::getIndexVersion)));
    }

    @Override
    public Map<Long, Long> getRelatedWorklogVersions(long parentIssueId) {
        return this.transactionSupportHelper.execute(() -> this.worklogVersionDao.getEntityVersionsRelatedToIssue(parentIssueId).stream().collect(Collectors.toMap(WorklogVersionDTO::getWorklogId, WorklogVersionDTO::getIndexVersion)));
    }

    @Override
    @VisibleForTesting
    public Map<Long, Optional<Long>> getLocalVersions(Set<Long> entityIds, IndexDirectoryFactory.Name indexName) throws IOException {
        switch (indexName) {
            case ISSUE: 
            case COMMENT: 
            case CHANGE_HISTORY: {
                return this.getLocalVersionsInOneQuery(entityIds, indexName);
            }
            case WORKLOG: {
                return this.getLocalVersionsOneByOne(entityIds, indexName);
            }
        }
        throw new IllegalArgumentException("Unknown index name " + (Object)((Object)indexName));
    }

    Map<Long, Optional<Long>> getLocalVersionsInOneQuery(Set<Long> entityIds, final IndexDirectoryFactory.Name indexName) throws IOException {
        ManagedIndexSearcher searcher = this.getSearcher(indexName);
        List entityIdsAsBytesRef = entityIds.stream().map(Object::toString).map(BytesRef::new).collect(Collectors.toList());
        TermInSetQuery matchesEntityIds = new TermInSetQuery(indexName.getEntityIdFieldName(), entityIdsAsBytesRef);
        Query hasVersion = LongPoint.newRangeQuery((String)indexName.getEntityVersionFieldName(), (long)Long.MIN_VALUE, (long)Long.MAX_VALUE);
        BooleanQuery query = new BooleanQuery.Builder().add((Query)matchesEntityIds, BooleanClause.Occur.MUST).add(hasVersion, BooleanClause.Occur.MUST).build();
        final HashMap<Long, Optional<Long>> idsToVersions = new HashMap<Long, Optional<Long>>();
        searcher.search((Query)query, (Collector)new FieldDocumentHitCollector(){
            private Set<String> fieldsToLoad;
            {
                this.fieldsToLoad = ImmutableSet.of((Object)indexName.getEntityIdFieldName(), (Object)indexName.getEntityVersionFieldName());
            }

            protected Set<String> getFieldsToLoad() {
                return this.fieldsToLoad;
            }

            public void collect(Document d) {
                idsToVersions.put(Long.valueOf(d.getField(indexName.getEntityIdFieldName()).stringValue()), Optional.of(d.getField(indexName.getEntityVersionFieldName()).numericValue().longValue()));
            }
        });
        entityIds.forEach(id -> idsToVersions.putIfAbsent((Long)id, Optional.empty()));
        return idsToVersions;
    }

    Map<Long, Optional<Long>> getLocalVersionsOneByOne(Set<Long> entityIds, IndexDirectoryFactory.Name indexName) throws IOException {
        ManagedIndexSearcher searcher = this.getSearcher(indexName);
        HashMap<Long, Optional<Long>> idsToVersions = new HashMap<Long, Optional<Long>>();
        for (Long entityId : entityIds) {
            Term idTerm = new Term(indexName.getEntityIdFieldName(), Long.toString(entityId));
            TopDocs docs = searcher.search((Query)new TermQuery(idTerm), 1);
            if (docs.scoreDocs.length > 0) {
                Optional<Long> version = indexName.getEntityVersionFromDocument(searcher.doc(docs.scoreDocs[0].doc, (Set)ImmutableSet.of((Object)indexName.getEntityVersionFieldName())));
                idsToVersions.put(entityId, version);
                continue;
            }
            idsToVersions.put(entityId, Optional.empty());
        }
        return idsToVersions;
    }

    public void cleanDeletedIssueVersion(long issueId) {
        this.transactionSupportHelper.executeWithRequiredNew(() -> {
            long deletedIssues = this.issueVersionDao.cleanDeletedVersion(issueId);
            if (deletedIssues > 0L) {
                this.commentVersionDao.cleanDeletedRelatedVersions(issueId);
                this.worklogVersionDao.cleanDeletedRelatedVersions(issueId);
            }
            return null;
        });
    }

    @Override
    public long cleanAllDeletedEntityVersionsOlderThan(Duration duration) {
        return this.transactionSupportHelper.executeWithRequiredNew(() -> this.issueVersionDao.cleanDeletedVersionsOlderThan(duration) + this.commentVersionDao.cleanDeletedVersionsOlderThan(duration) + this.worklogVersionDao.cleanDeletedVersionsOlderThan(duration));
    }

    @Override
    public List<EntityVersion> findEntityVersionsUpdatedInTheLast(IndexDirectoryFactory.Name indexName, Duration duration) {
        switch (indexName) {
            case ISSUE: {
                return this.findEntityVersionsUpdatedInTheLast(this.issueVersionDao, EntityVersion::new, duration);
            }
            case COMMENT: {
                return this.findEntityVersionsUpdatedInTheLast(this.commentVersionDao, EntityVersion::new, duration);
            }
            case WORKLOG: {
                return this.findEntityVersionsUpdatedInTheLast(this.worklogVersionDao, EntityVersion::new, duration);
            }
        }
        throw new IllegalArgumentException("unrecognized index type " + (Object)((Object)indexName));
    }

    private <D extends DTO> List<EntityVersion> findEntityVersionsUpdatedInTheLast(VersioningDao<?, D> dao, Function<D, EntityVersion> dtoToEntityVersion, Duration duration) {
        return dao.findVersionsUpdatedInTheLast(duration).stream().map(dtoToEntityVersion).collect(Collectors.toList());
    }

    @Override
    public Optional<EntityVersion> getLatestEntityUpdate(IndexDirectoryFactory.Name indexName) {
        switch (indexName) {
            case ISSUE: {
                return this.issueVersionDao.getMostRecentlyUpdatedVersion().map(EntityVersion::new);
            }
            case COMMENT: {
                return this.commentVersionDao.getMostRecentlyUpdatedVersion().map(EntityVersion::new);
            }
            case WORKLOG: {
                return this.worklogVersionDao.getMostRecentlyUpdatedVersion().map(EntityVersion::new);
            }
        }
        throw new IllegalArgumentException("unrecognized index type " + (Object)((Object)indexName));
    }

    private void incrementVersion(VersioningDao versioningDao, long entityId, @Nullable Long parentIssueId) throws IncrementDeletedEntityVersionException {
        if (this.transactionSupportHelper.executeWithRequiredNew(() -> versioningDao.incrementEntityVersionAndUpdateTimestamp(entityId)) == 0L) {
            try {
                this.transactionSupportHelper.executeWithRequiredNew(() -> versioningDao.insertInitialVersionRow(entityId, parentIssueId));
            }
            catch (Exception alreadyExists) {
                String entityName = versioningDao.getEntityName();
                log.trace("[VERSIONING] Inserting the initial " + entityName + " row failed. We assume the error is a unique constraint violation on the entity's Id column, meaning someone else has just added a row for this entity, so now we can try to increment version in the existing row.", (Throwable)alreadyExists);
                if (this.transactionSupportHelper.executeWithRequired(() -> versioningDao.isMarkedAsDeleted(entityId)).booleanValue()) {
                    throw new IncrementDeletedEntityVersionException(entityName, entityId);
                }
                this.transactionSupportHelper.executeWithRequiredNew(() -> versioningDao.incrementEntityVersionAndUpdateTimestamp(entityId));
            }
        }
    }

    private void markAsDeletedAndIncrementVersion(VersioningDao versioningDao, long entityId) throws IncrementDeletedEntityVersionException {
        if (this.transactionSupportHelper.executeWithRequiredNew(() -> versioningDao.markDeletedAndUpdateVersion(entityId)) == 0L) {
            try {
                this.transactionSupportHelper.executeWithRequiredNew(() -> versioningDao.insertDeleteVersionRow(entityId));
            }
            catch (Exception alreadyExists) {
                String entityName = versioningDao.getEntityName();
                if (this.transactionSupportHelper.executeWithRequired(() -> versioningDao.isMarkedAsDeleted(entityId)).booleanValue()) {
                    throw new IncrementDeletedEntityVersionException(entityName, entityId);
                }
                log.trace("[VERSIONING] Inserting the marked as deleted record for " + entityName + " row failed. We assume the error is a unique constraint violation on the entity's Id column, meaning someone else has just added a row for this entity, so now we can try to mark as deleted and increment version in the existing row.", (Throwable)alreadyExists);
                this.transactionSupportHelper.executeWithRequiredNew(() -> versioningDao.markDeletedAndUpdateVersion(entityId));
            }
        }
    }

    private ManagedIndexSearcher getSearcher(IndexDirectoryFactory.Name indexName) {
        InternalIndexingService indexManager = (InternalIndexingService)ComponentAccessor.getComponent(InternalIndexingService.class);
        return indexManager.getEntitySearcher(indexName);
    }
}

