/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.jira.config.util.AttachmentConfig;
import com.atlassian.jira.config.util.AttachmentConfigStore;
import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.config.util.ExtensionRestrictionMode;
import com.atlassian.jira.filestore.AttachmentFileStoreProvider;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.admin.ViewAttachmentSettings;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

@WebSudoRequired
public class EditAttachmentSettings
extends ViewAttachmentSettings {
    private boolean thumbnailsEnabled;
    private boolean zipSupport;
    private String customAttachmentPath;
    private String maxAttachmentSize;
    private boolean attachmentsEnabled;
    private boolean customAttachmentPathSelectedInUi;
    private String extensionRestrictionMode;
    private String filteredFileExtensions;
    private boolean filterFilesWithoutExtensions;

    public EditAttachmentSettings(ProjectManager projectManager, PermissionManager permissionManager, AttachmentFileStoreProvider attachmentFileStoreProvider, AttachmentPathManager attachmentPathManager, AttachmentConfigStore attachmentConfigStore, PageBuilderService pageBuilderService) {
        super(projectManager, permissionManager, attachmentFileStoreProvider, attachmentPathManager, attachmentConfigStore, pageBuilderService);
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        AttachmentConfig config = this.attachmentConfigStore.getConfig();
        this.attachmentsEnabled = config.isAttachmentsEnabled();
        this.customAttachmentPathSelectedInUi = this.isAttachmentModeCustom();
        this.customAttachmentPath = this.customAttachmentPathSelectedInUi ? this.attachmentPathManager.getAttachmentPath() : null;
        this.maxAttachmentSize = String.valueOf(config.getMaxAttachmentSize());
        this.thumbnailsEnabled = config.isThumbnailsEnabled();
        this.zipSupport = config.isZipSupportEnabled();
        this.extensionRestrictionMode = config.getExtensionRestrictionMode().getKey();
        this.filteredFileExtensions = config.getFilteredFileExtensions();
        this.filterFilesWithoutExtensions = config.isFilterFilesWithoutExtensions();
        return "input";
    }

    protected void doValidation() {
        AttachmentConfig config = this.attachmentConfigStore.getConfig();
        this.customAttachmentPathSelectedInUi &= this.isAttachmentModeCustom();
        if (!this.isSystemAdministrator()) {
            this.attachmentsEnabled = config.isAttachmentsEnabled();
            this.customAttachmentPathSelectedInUi = this.isAttachmentModeCustom();
        }
        AttachmentConfig.Builder configBuilder = config.copy().setAttachmentsEnabled(this.attachmentsEnabled).setThumbnailsEnabled(this.thumbnailsEnabled).setZipSupportEnabled(this.zipSupport).setFilteredFileExtensions(this.filteredFileExtensions).setFilterFilesWithoutExtensions(this.filterFilesWithoutExtensions);
        this.parseMaxAttachmentSize().ifPresent(configBuilder::setMaxAttachmentSize);
        this.parseExtensionRestrictionMode().ifPresent(configBuilder::setExtensionRestrictionMode);
        ErrorCollection errors = this.attachmentConfigStore.validateConfig(configBuilder.build());
        errors.getErrorMessages().forEach(errorKey -> this.addErrorMessage(this.getText((String)errorKey)));
        errors.getErrors().forEach((field, errorKey) -> this.addError((String)field, this.getText((String)errorKey)));
        super.doValidation();
    }

    private Optional<Long> parseMaxAttachmentSize() {
        String maxAttachmentSizeFieldName = "maxAttachmentSize";
        Optional<Long> result = Optional.empty();
        if (StringUtils.isBlank((CharSequence)this.maxAttachmentSize)) {
            this.addError("maxAttachmentSize", this.getText("admin.errors.attachments.size.required"));
        } else {
            try {
                result = Optional.of(Long.parseLong(this.maxAttachmentSize));
            }
            catch (NumberFormatException e) {
                this.addError("maxAttachmentSize", this.getText("admin.errors.attachments.size.must.be.between", String.valueOf(Integer.MAX_VALUE)));
            }
        }
        return result;
    }

    private Optional<ExtensionRestrictionMode> parseExtensionRestrictionMode() {
        String fieldName = "extensionRestrictionMode";
        Optional<ExtensionRestrictionMode> result = ExtensionRestrictionMode.fromKey(this.extensionRestrictionMode);
        if (!result.isPresent()) {
            this.addError("extensionRestrictionMode", this.getText("admin.errors.attachments.invalid.extension.restriction.mode"));
        }
        return result;
    }

    @Override
    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    protected String doExecute() throws Exception {
        AttachmentConfig config = this.attachmentConfigStore.getConfig();
        if (this.isSystemAdministrator() && !this.isCustomAttachmentPathSelectedInUi() && this.isAttachmentModeCustom()) {
            this.attachmentPathManager.setUseDefaultDirectory();
        }
        AttachmentConfig.Builder configBuilder = config.copy().setThumbnailsEnabled(this.thumbnailsEnabled).setMaxAttachmentSize(Long.parseLong(this.maxAttachmentSize)).setZipSupportEnabled(this.zipSupport).setExtensionRestrictionMode(ExtensionRestrictionMode.fromKey(this.extensionRestrictionMode).orElseThrow(IllegalStateException::new)).setFilteredFileExtensions(this.filteredFileExtensions).setFilterFilesWithoutExtensions(this.filterFilesWithoutExtensions);
        if (this.isSystemAdministrator()) {
            configBuilder.setAttachmentsEnabled(this.attachmentsEnabled);
        }
        this.attachmentConfigStore.setConfig(configBuilder.build());
        return this.returnComplete("ViewAttachmentSettings.jspa");
    }

    public String getMaxAttachmentSize() {
        if (this.maxAttachmentSize == null) {
            this.maxAttachmentSize = String.valueOf(this.attachmentConfigStore.getConfig().getMaxAttachmentSize());
        }
        return this.maxAttachmentSize;
    }

    public boolean isAttachmentsEnabled() {
        return this.attachmentsEnabled;
    }

    public void setAttachmentsEnabled(boolean enabled) {
        this.attachmentsEnabled = enabled;
    }

    public boolean isCustomAttachmentPathSelectedInUi() {
        return this.customAttachmentPathSelectedInUi;
    }

    public void setCustomAttachmentPathSelectedInUi(boolean enabled) {
        this.customAttachmentPathSelectedInUi = enabled;
    }

    public boolean isThumbnailsEnabled() {
        return this.thumbnailsEnabled;
    }

    public void setThumbnailsEnabled(boolean thumbnailsEnabled) {
        this.thumbnailsEnabled = thumbnailsEnabled;
    }

    public void setMaxAttachmentSize(String maxAttachmentSize) {
        this.maxAttachmentSize = maxAttachmentSize;
    }

    public boolean isZipSupport() {
        return this.zipSupport;
    }

    public void setZipSupport(boolean zipSupport) {
        this.zipSupport = zipSupport;
    }

    public String getCustomAttachmentPath() {
        return this.customAttachmentPath;
    }

    @Override
    public String getExtensionRestrictionMode() {
        return this.extensionRestrictionMode;
    }

    public void setExtensionRestrictionMode(String extensionRestrictionMode) {
        this.extensionRestrictionMode = extensionRestrictionMode;
    }

    @Override
    public String getFilteredFileExtensions() {
        return this.filteredFileExtensions;
    }

    public void setFilteredFileExtensions(String filteredFileExtensions) {
        this.filteredFileExtensions = filteredFileExtensions;
    }

    @Override
    public boolean isFilterFilesWithoutExtensions() {
        return this.filterFilesWithoutExtensions;
    }

    public void setFilterFilesWithoutExtensions(boolean filterFilesWithoutExtensions) {
        this.filterFilesWithoutExtensions = filterFilesWithoutExtensions;
    }
}

