/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.appconsistency.integrity.IntegrityCheckManager;
import com.atlassian.jira.appconsistency.integrity.amendment.Amendment;
import com.atlassian.jira.appconsistency.integrity.check.Check;
import com.atlassian.jira.appconsistency.integrity.integritycheck.CheckIntegrityOperation;
import com.atlassian.jira.appconsistency.integrity.integritycheck.FixIntegrityOperation;
import com.atlassian.jira.appconsistency.integrity.integritycheck.IntegrityCheck;
import com.atlassian.jira.appconsistency.integrity.integritycheck.IntegrityCheckerCallable;
import com.atlassian.jira.appconsistency.integrity.integritycheck.IntegrityCheckerCommandResult;
import com.atlassian.jira.appconsistency.integrity.integritycheck.IntegrityCheckerTaskContext;
import com.atlassian.jira.appconsistency.integrity.integritycheck.ProgressAwareIntegrityCheckerOperation;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.event.operation.SpanningOperation;
import com.atlassian.jira.event.operation.SpanningOperationType;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.bean.TaskDescriptorBean;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import webwork.action.ActionContext;

@WebSudoRequired
public class IntegrityChecker
extends JiraWebActionSupport {
    private static final String INTEGRITY_CHECK_PREFIX = "integrity_";
    private static final String CHECK_PREFIX = "check_";
    private static final String RESULT_NOT_POPULATED = "Check result has not been populated yet.";
    private static final String DEFAULT_INTEGRITY_CHECKER_RETURN_URL = "IntegrityChecker!default.jspa";
    private static final String FIX_OPERATION = "Fix";
    private static final String CHECK_OPERATION = "Check";
    private static final String DESTINATION_URL_URL_PARAMETER = "&destinationURL=";
    private final transient FeatureManager featureManager;
    private final IntegrityCheckManager integrityCheckManager;
    private final transient TaskManager taskManager;
    private final com.atlassian.jira.appconsistency.integrity.IntegrityChecker integrityChecker;
    private final transient TaskDescriptorBean.Factory taskBeanFactory;
    private transient TaskDescriptorBean<IntegrityCheckerCommandResult> currentTask;
    private Map<Long, List<Amendment>> results = null;
    private Map<String, String[]> contextParameters = ActionContext.getParameters();
    private Long taskId;
    private String check;
    private String fix;
    private String back;
    private String destinationURL;

    public IntegrityChecker(FeatureManager featureManager, IntegrityCheckManager integrityCheckManager, com.atlassian.jira.appconsistency.integrity.IntegrityChecker integrityChecker, TaskManager taskManager, TaskDescriptorBean.Factory taskBeanFactory) {
        this.featureManager = featureManager;
        this.integrityCheckManager = integrityCheckManager;
        this.integrityChecker = integrityChecker;
        this.taskManager = taskManager;
        this.taskBeanFactory = taskBeanFactory;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        if (this.featureManager.isEnabled(JiraFeatureFlagRegistrar.INTEGRITY_CHECKER_TASK_CLEANUP)) {
            this.cleanUpFinishedIntegrityCheckerTasks();
        }
        return super.doDefault();
    }

    protected void doValidation() {
        if (!(TextUtils.stringSet((String)this.getCheck()) || TextUtils.stringSet((String)this.getFix()) || TextUtils.stringSet((String)this.getBack()))) {
            this.addErrorMessage(this.getText("admin.integritychecker.error.no.function"));
        } else if (!(this.isCheck() || this.isFix() || this.isBack())) {
            this.addErrorMessage(this.getText("admin.integritychecker.error.no.function"));
        }
        List<Long> checkIds = this.getCheckIds();
        if (this.isCheck() && checkIds.isEmpty()) {
            this.addErrorMessage(this.getText("admin.integritychecker.error.one.check"));
        }
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST, RequestMethod.GET})
    protected String doExecute() throws Exception {
        if (this.isCheck()) {
            String progressUrl = this.submitIntegrityCheckerOperationTask(new CheckIntegrityOperation(this.getI18nHelper(), this.integrityChecker), SpanningOperationType.INTEGRITY_CHECK);
            return this.getRedirect(progressUrl + DESTINATION_URL_URL_PARAMETER + this.getDestinationURL());
        }
        if (this.isFix()) {
            String progressUrl = this.submitIntegrityCheckerOperationTask(new FixIntegrityOperation(this.getI18nHelper(), this.integrityChecker), SpanningOperationType.INTEGRITY_FIX);
            return this.getRedirect(progressUrl + DESTINATION_URL_URL_PARAMETER + this.getDestinationURL());
        }
        if (this.isBack()) {
            return this.getRedirect(DEFAULT_INTEGRITY_CHECKER_RETURN_URL);
        }
        return "input";
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doProgress() {
        IntegrityCheckerCommandResult result;
        if (this.taskId == null) {
            this.addErrorMessage(this.getText("common.tasks.no.task.id"));
            return "error";
        }
        TaskDescriptor taskDescriptor = this.taskManager.getTask(this.taskId);
        if (taskDescriptor == null) {
            this.addErrorMessage(this.getText("common.tasks.no.task.found"));
            return "error";
        }
        TaskContext context = taskDescriptor.getTaskContext();
        if (!(context instanceof IntegrityCheckerTaskContext)) {
            this.addErrorMessage(this.getText("common.tasks.wrong.task.context", IntegrityCheckerTaskContext.class.getName(), context.getClass().getName()));
            return "error";
        }
        this.currentTask = this.taskBeanFactory.create(taskDescriptor);
        if (taskDescriptor.isFinished() && !taskDescriptor.isCancelled() && !(result = (IntegrityCheckerCommandResult)taskDescriptor.getResult()).isSuccessful()) {
            this.addErrorCollection(result.getErrorCollection());
        }
        return "progress";
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doAcknowledge() {
        if (this.taskId != null) {
            ApplicationUser currentUser;
            TaskDescriptor descriptor = this.taskManager.getTask(this.taskId);
            if (descriptor != null && descriptor.isFinished() && (currentUser = this.getLoggedInUser()) != null && !currentUser.getName().equals(descriptor.getUserName())) {
                this.addErrorMessage(this.getText("common.tasks.cant.acknowledge.task.you.didnt.start", descriptor.getUserName()));
                return "error";
            }
            if (this.destinationURL != null) {
                return this.getRedirect(this.destinationURL + "?taskId=" + this.taskId);
            }
            this.taskManager.removeTask(this.taskId);
            this.addErrorMessage(this.getText("admin.integritychecker.missing.return.url", this.taskId));
            return "error";
        }
        return "success";
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doPreview() {
        this.setCheck(CHECK_OPERATION);
        return this.validateAndSetTheResults("preview");
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doCorrect() {
        this.setFix(FIX_OPERATION);
        return this.validateAndSetTheResults("correct");
    }

    private String validateAndSetTheResults(String viewToReturn) {
        TaskDescriptor taskDescriptor = this.taskManager.getTask(this.taskId);
        if (taskDescriptor == null) {
            this.addErrorMessage(this.getText("common.tasks.no.task.found"));
            return "error";
        }
        IntegrityCheckerCommandResult commandResult = (IntegrityCheckerCommandResult)taskDescriptor.getResult();
        this.taskManager.removeTask(this.taskId);
        if (commandResult == null) {
            this.addErrorMessage(this.getText("common.tasks.no.results.found"));
            return "error";
        }
        if (!commandResult.isSuccessful()) {
            this.addErrorMessages(commandResult.getErrorCollection().getErrorMessages());
            return "error";
        }
        this.results = commandResult.getResults();
        this.contextParameters = commandResult.getContextParameters();
        return viewToReturn;
    }

    private void resolveReturnUrl() {
        String returnURL = DEFAULT_INTEGRITY_CHECKER_RETURN_URL;
        if (this.isCheck()) {
            returnURL = "IntegrityChecker!preview.jspa";
        }
        if (this.isFix()) {
            returnURL = "IntegrityChecker!correct.jspa";
        }
        this.setDestinationURL(StringUtils.isNotBlank((CharSequence)this.getReturnUrl()) ? this.getReturnUrl() : returnURL);
        this.setReturnUrl(null);
    }

    private String submitIntegrityCheckerOperationTask(ProgressAwareIntegrityCheckerOperation operation, SpanningOperationType type) {
        this.resolveReturnUrl();
        Map contextParameters = ActionContext.getParameters();
        List<Long> checks = this.getCheckIds();
        String taskName = this.getText(operation.getOperationProgressKey(), checks.size());
        SpanningOperation spanningOperation = SpanningOperation.builder().generatedId().type(type).build();
        ApplicationUser user = this.getLoggedInUser();
        IntegrityCheckerTaskContext context = new IntegrityCheckerTaskContext(user.getUsername(), operation.getOperationName());
        TaskDescriptor taskDescriptor = this.taskManager.getLiveTask(context);
        if (taskDescriptor != null) {
            this.log.debug((Object)("An existing task found for " + context + ", not starting another one."));
            return this.getRedirect(taskDescriptor.getProgressURL());
        }
        this.log.debug((Object)("Submitting a new task with task manager: " + context));
        IntegrityCheckerCallable command = new IntegrityCheckerCallable(this.log, this.getI18nHelper(), operation, checks, contextParameters);
        return this.taskManager.submitTask(command, taskName, context, false, spanningOperation).getProgressURL();
    }

    private void cleanUpFinishedIntegrityCheckerTasks() {
        this.taskManager.getLiveTasks().stream().filter(TaskDescriptor::isFinished).filter(task -> task.getSpanningOperation() != null && (SpanningOperationType.INTEGRITY_CHECK.name().equals(task.getSpanningOperation().getType()) || SpanningOperationType.INTEGRITY_FIX.name().equals(task.getSpanningOperation().getType()))).forEach(task -> this.taskManager.removeTask(task.getTaskId()));
    }

    public String getIntegrityCheckPrefix() {
        return INTEGRITY_CHECK_PREFIX;
    }

    public String getCheckPrefix() {
        return this.getIntegrityCheckPrefix() + CHECK_PREFIX;
    }

    public String getCheckId(Check check) {
        return this.getCheckPrefix() + check.getIntegrityCheck().getId().toString() + "_" + check.getId().toString();
    }

    public boolean isHasCorrectableResults() {
        Map<Long, List<Amendment>> checkResults = this.getResults();
        for (Long checkId : checkResults.keySet()) {
            if (!this.isHasCorrectableResults(checkId)) continue;
            return true;
        }
        return false;
    }

    public boolean isHasCorrectableResults(Long checkId) {
        List<Amendment> amendments = this.results.get(checkId);
        if (amendments != null && !amendments.isEmpty()) {
            for (Amendment amendment : amendments) {
                if (!amendment.isError()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isHasCorrectableResults(IntegrityCheck integrityCheck) {
        List<? extends Check> checks = integrityCheck.getChecks();
        for (Check check : checks) {
            if (!this.isHasCorrectableResults(check.getId())) continue;
            return true;
        }
        return false;
    }

    public boolean isHasWarningResults(Long checkId) {
        List<Amendment> amendments = this.results.get(checkId);
        if (amendments != null && !amendments.isEmpty()) {
            for (Amendment amendment : amendments) {
                if (!amendment.isWarning()) continue;
                return true;
            }
        }
        return false;
    }

    public List<IntegrityCheck> getIntegrityChecks() {
        return this.integrityCheckManager.getIntegrityChecks();
    }

    public boolean isIntegrityCheckAvailable(IntegrityCheck integrityCheck) {
        if (!integrityCheck.isAvailable()) {
            return false;
        }
        if (this.isBack()) {
            return true;
        }
        if (this.isCheck()) {
            return this.isHasCorrectableResults(integrityCheck);
        }
        if (this.isFix()) {
            return false;
        }
        throw new IllegalStateException("Invalid function was selected.");
    }

    public boolean isCheckAvailable(Check check) {
        if (!check.isAvailable()) {
            return false;
        }
        if (this.isBack()) {
            return true;
        }
        if (this.isCheck()) {
            return this.isHasCorrectableResults(check.getId());
        }
        if (this.isFix()) {
            return false;
        }
        throw new IllegalStateException("Invalid function was selected.");
    }

    public boolean isChecked(Check check) {
        return this.contextParameters.containsKey(this.getCheckId(check));
    }

    public Map<Long, List<Amendment>> getResults() {
        if (this.results == null) {
            throw new IllegalStateException(RESULT_NOT_POPULATED);
        }
        return this.results;
    }

    public int getTotalResults() {
        int total = 0;
        Map<Long, List<Amendment>> checkResults = this.getResults();
        if (checkResults != null) {
            for (Map.Entry<Long, List<Amendment>> entry : checkResults.entrySet()) {
                List<Amendment> amendments = entry.getValue();
                if (amendments == null) continue;
                for (Amendment amendment : amendments) {
                    if (!amendment.isCorrection()) continue;
                    ++total;
                }
            }
        }
        return total;
    }

    public TaskDescriptorBean<IntegrityCheckerCommandResult> getCurrentTask() {
        TaskDescriptor taskDescriptor;
        if (this.currentTask == null && (taskDescriptor = this.taskManager.getTask(this.taskId)) != null) {
            this.currentTask = this.taskBeanFactory.create(taskDescriptor);
        }
        return this.currentTask;
    }

    private List<Long> getCheckIds() {
        ArrayList<Long> checkIds = new ArrayList<Long>();
        Map<String, String[]> parameters = this.contextParameters;
        Set<String> keys = parameters.keySet();
        for (String key : keys) {
            if (!key.startsWith(this.getCheckPrefix())) continue;
            try {
                checkIds.add(Long.valueOf(parameters.get(key)[0]));
            }
            catch (NumberFormatException e) {
                this.log.error((Object)e, (Throwable)e);
            }
        }
        return checkIds;
    }

    private boolean isCheck() {
        return this.check != null;
    }

    private boolean isFix() {
        return this.fix != null;
    }

    private boolean isBack() {
        return this.back != null;
    }

    public String getCheck() {
        return this.check;
    }

    public void setCheck(String check) {
        this.check = check;
    }

    public String getFix() {
        return this.fix;
    }

    public void setFix(String fix) {
        this.fix = fix;
    }

    public String getBack() {
        return this.back;
    }

    public void setBack(String back) {
        this.back = back;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public String getDestinationURL() {
        return this.destinationURL;
    }

    public void setDestinationURL(String destinationURL) {
        this.destinationURL = destinationURL;
    }
}

