/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.application.JiraApplication;
import com.atlassian.jira.project.type.JiraApplicationAdapter;
import com.atlassian.jira.project.type.ProjectType;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.landingpage.LandingPageRedirector;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSudoRequired
public class LandingPage
extends JiraWebActionSupport {
    private static final Logger log = LoggerFactory.getLogger(LandingPage.class);
    @Nonnull
    private final LandingPageRedirector landingPageRedirector;
    @Nonnull
    private final PageBuilderService pageBuilderService;
    @Nonnull
    private final JiraApplicationAdapter jiraApplicationAdapter;
    @Nonnull
    private Optional<String> product = Optional.empty();
    private String projectTypeKey;
    private String productName;

    public LandingPage(@Nonnull LandingPageRedirector landingPageRedirector, @Nonnull PageBuilderService pageBuilderService, @Nonnull JiraApplicationAdapter jiraApplicationAdapter) {
        this.landingPageRedirector = landingPageRedirector;
        this.pageBuilderService = pageBuilderService;
        this.jiraApplicationAdapter = jiraApplicationAdapter;
    }

    protected void doValidation() {
        this.product.filter(key -> !ApplicationKey.isValid((String)key)).ifPresent(key -> log.warn("Incorrect application key: " + key));
        this.product.filter(ApplicationKey::isValid).filter(key -> !this.getForApplicationKey((String)key).isPresent()).ifPresent(key -> log.warn("Did not found application for key: " + key));
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        this.handleSelectedProduct();
        this.pageBuilderService.assembler().resources().requireContext("atl.general").requireContext("atl.admin").requireWebResource("jira.webresources:landingpage");
        return this.landingPageRedirector.redirectUrl(this.getLoggedInUser()).map(arg_0 -> ((LandingPage)this).getRedirect(arg_0)).orElse("success");
    }

    @VisibleForTesting
    void handleSelectedProduct() {
        Optional<Object> selectedProduct = this.product.flatMap(this::getForApplicationKey);
        this.projectTypeKey = selectedProduct.map(application -> StreamSupport.stream(application.getProjectTypes().spliterator(), false)).flatMap(Stream::findFirst).map(ProjectType::getKey).map(ProjectTypeKey::getKey).orElse("");
        this.productName = selectedProduct.map(JiraApplication::getName).orElse("JIRA");
    }

    public void setProduct(@Nullable String product) {
        this.product = Optional.ofNullable(product);
    }

    @ActionViewData
    public String getProjectTypeKey() throws Exception {
        return this.projectTypeKey;
    }

    @ActionViewData
    public String getProductName() throws Exception {
        return this.productName;
    }

    private Optional<JiraApplication> getForApplicationKey(String applicationKey) {
        return Optional.of(applicationKey).filter(ApplicationKey::isValid).map(ApplicationKey::valueOf).flatMap(this::getApplication);
    }

    private Optional<JiraApplication> getApplication(ApplicationKey applicationKey) {
        return StreamSupport.stream(this.jiraApplicationAdapter.getAccessibleJiraApplications().spliterator(), false).filter(application -> applicationKey.equals((Object)application.getKey())).findFirst();
    }
}

