/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.configurableobjects.ConfigurableObjectUtil;
import com.atlassian.jira.plugin.ComponentClassManager;
import com.atlassian.jira.scheduler.cron.CronValidator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.service.InBuiltServiceTypes;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.service.ServiceTypes;
import com.atlassian.jira.service.services.file.FileService;
import com.atlassian.jira.service.services.mail.MailFetcherService;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.component.cron.CronEditorBean;
import com.atlassian.jira.web.component.cron.CronEditorWebComponent;
import com.atlassian.jira.web.component.cron.generator.CronExpressionDescriptor;
import com.atlassian.jira.web.component.cron.generator.CronExpressionGenerator;
import com.atlassian.jira.web.component.cron.generator.CronIntervalGenerator;
import com.atlassian.jira.web.component.cron.parser.CronExpressionParser;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.scheduler.SchedulerService;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.ActionContext;

@WebSudoRequired
public class ViewServices
extends JiraWebActionSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ViewServices.class);
    private final ServiceManager serviceManager;
    private final ComponentClassManager componentClassManager;
    private final ServiceTypes serviceTypes;
    private final InBuiltServiceTypes inBuiltServiceTypes;
    private final JiraAuthenticationContext authenticationContext;
    private final SchedulerService schedulerService;
    private Long delete;
    private String name;
    private String clazz;
    private CronEditorBean cronEditorBean;

    public ViewServices(ServiceManager serviceManager, ComponentClassManager componentClassManager, InBuiltServiceTypes inBuiltServiceTypes, ServiceTypes serviceTypes, JiraAuthenticationContext authenticationContext, SchedulerService schedulerService) {
        this.serviceManager = serviceManager;
        this.componentClassManager = componentClassManager;
        this.inBuiltServiceTypes = inBuiltServiceTypes;
        this.serviceTypes = serviceTypes;
        this.authenticationContext = authenticationContext;
        this.schedulerService = schedulerService;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    protected void doValidation() {
        if (this.delete == null) {
            if (this.name == null || "".equals(this.name.trim())) {
                this.addError("name", this.getText("admin.errors.specify.service.name"));
            }
            if (this.clazz == null || "".equals(this.clazz.trim())) {
                this.addError("clazz", this.getText("admin.errors.specify.service.class"));
            }
            boolean serviceExists = false;
            for (JiraServiceContainer service : this.serviceManager.getServices()) {
                if (this.name.equalsIgnoreCase(service.getName())) {
                    this.addError("name", this.getText("admin.errors.service.with.name.exists", this.name));
                }
                if (!this.clazz.equals(service.getServiceClass())) continue;
                serviceExists = service.isUnique();
            }
            if (!this.getHasErrors()) {
                try {
                    this.componentClassManager.newInstance(this.clazz);
                    if (serviceExists) {
                        this.addError("clazz", this.getText("admin.errors.cannot.add.service"));
                    }
                }
                catch (ClassNotFoundException ex) {
                    this.addError("clazz", this.getText("admin.errors.class.not.found", this.clazz));
                    this.log.debug((Object)("Class [" + this.clazz + "] was not found when adding service"), (Throwable)ex);
                }
                catch (ClassCastException e) {
                    this.addError("clazz", this.getText("admin.errors.incorrect.class.type", this.clazz));
                    this.log.debug((Object)("Class [" + this.clazz + "] is not of type JiraService"), (Throwable)e);
                }
                catch (Exception e) {
                    this.addError("clazz", this.getText("admin.errors.exception.loading.class") + " [" + e.getMessage() + "].");
                    this.log.debug((Object)("Exception loading class: [" + e.getMessage() + "]"), (Throwable)e);
                }
            }
            this.cronEditorBean = new CronEditorBean("service.schedule", ActionContext.getParameters());
            CronEditorWebComponent component = new CronEditorWebComponent();
            this.addErrorCollection(component.validateInput(this.cronEditorBean, "cron.editor.name"));
            if (!this.hasAnyErrors()) {
                JiraServiceContext serviceContext = this.getJiraServiceContext();
                String cronString = component.getCronExpressionFromInput(this.cronEditorBean);
                Option<String> cronError = new CronValidator(this.authenticationContext.getI18nHelper(), this.schedulerService).validateCron(cronString);
                if (cronError.isDefined()) {
                    serviceContext.getErrorCollection().addError("cron.editor.name", (String)cronError.get());
                }
            }
        }
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (this.delete != null) {
            if (this.canDeleteService(this.delete)) {
                LOG.debug("Removing Service with id " + this.delete);
                this.serviceManager.removeService(this.delete);
                return this.getRedirect("ViewServices!default.jspa");
            }
            return "securitybreach";
        }
        if (this.name != null && this.clazz != null) {
            if (this.canAddService(this.clazz)) {
                try {
                    String cronExpression = new CronExpressionGenerator().getCronExpressionFromInput(this.cronEditorBean);
                    long delay = new CronIntervalGenerator().getDelayFromInput(this.cronEditorBean);
                    JiraServiceContainer serviceContainer = this.serviceManager.addService(this.getName(), this.getClazz(), cronExpression, delay, null);
                    return this.getRedirect("EditService!default.jspa?id=" + serviceContainer.getId());
                }
                catch (Exception e) {
                    this.log.error((Object)("Unable to add service: " + this.getName()), (Throwable)e);
                    this.addErrorMessage(this.getText("admin.errors.error.adding.service") + " " + e.toString() + ".");
                }
            } else {
                return "securitybreach";
            }
        }
        return this.getRedirect("ViewServices!default.jspa");
    }

    private boolean canAddService(String clazz) {
        return this.serviceTypes.isManageableBy(this.getLoggedInUser(), clazz);
    }

    private boolean canDeleteService(final Long serviceId) throws Exception {
        return Iterables.any((Iterable)this.serviceManager.getServicesManageableBy(this.getLoggedInUser()), (Predicate)new Predicate<JiraServiceContainer>(){

            public boolean apply(@Nullable JiraServiceContainer aServiceManageableByTheUser) {
                return serviceId.equals(aServiceManageableByTheUser.getId());
            }
        });
    }

    public Collection<JiraServiceContainer> getServices() {
        return ImmutableList.copyOf((Iterable)this.serviceManager.getServicesManageableBy(this.getLoggedInUser()));
    }

    public CronEditorBean getCronEditorBean() {
        if (this.cronEditorBean == null) {
            this.cronEditorBean = new CronExpressionParser().getCronEditorBean();
        }
        return this.cronEditorBean;
    }

    public void setCronEditorBean(CronEditorBean cronEditorBean) {
        this.cronEditorBean = cronEditorBean;
    }

    public Collection getInBuiltServiceTypes() {
        return ImmutableSet.copyOf((Iterable)Iterables.filter(this.inBuiltServiceTypes.manageableBy(this.getLoggedInUser()), (Predicate)new Predicate<InBuiltServiceTypes.InBuiltServiceType>(){

            public boolean apply(InBuiltServiceTypes.InBuiltServiceType input) {
                return input.getType() != null && !ViewServices.this.isMailRelatedServiceClass(input.getType());
            }
        }));
    }

    public Map getPropertyMap(JiraServiceContainer serviceContainer) throws Exception {
        try {
            return ConfigurableObjectUtil.getPropertyMap(serviceContainer);
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            return MapBuilder.build((Object)"ERROR", (Object)"Error occurred getting properties. See log file for details.");
        }
    }

    public long getDelayInMins(JiraServiceContainer serviceContainer) {
        return serviceContainer.getDelay() / 60000L;
    }

    public String getPrettyCron(JiraServiceContainer serviceContainer) {
        String cronExpression = serviceContainer.getCronExpression();
        if (cronExpression != null) {
            CronExpressionParser cronExpresionParser = new CronExpressionParser(cronExpression);
            if (cronExpresionParser.isValidForEditor()) {
                CronEditorBean cronEditorBean = cronExpresionParser.getCronEditorBean();
                return new CronExpressionDescriptor(this.getI18nHelper()).getPrettySchedule(cronEditorBean);
            }
            return cronExpression;
        }
        long delayInMins = this.getDelayInMins(serviceContainer);
        if (delayInMins > 0L) {
            String i18nKey = delayInMins == 1L ? "admin.services.delay.pretty.single" : "admin.services.delay.pretty.plural";
            return this.getI18nHelper().getText(i18nKey, (Object)delayInMins);
        }
        return "";
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public void setClazz(String clazz) {
        this.clazz = clazz.trim();
    }

    public String getName() {
        return this.name;
    }

    public String getClazz() {
        return this.clazz;
    }

    public void setDelete(Long delete) {
        this.delete = delete;
    }

    public boolean isHandlerUsingObsoleteSettings(JiraServiceContainer service) {
        try {
            Map<String, String> params = ConfigurableObjectUtil.getPropertyMap(service);
            return params != null && params.containsKey("handler.params") && (params.get("handler.params").contains("port=") || params.get("handler.params").contains("usessl="));
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isMailRelatedServiceClass(Class<?> clazz) {
        return MailFetcherService.class.isAssignableFrom(clazz) || FileService.class.isAssignableFrom(clazz);
    }

    public boolean isEditable(JiraServiceContainer serviceContainer) {
        if (serviceContainer == null || serviceContainer.getServiceClass() == null) {
            return false;
        }
        try {
            Class serviceClass = this.componentClassManager.loadClass(serviceContainer.getServiceClass());
            return !this.isMailRelatedServiceClass(serviceClass);
        }
        catch (ClassNotFoundException e) {
            return true;
        }
    }

    public String getHelpLink() {
        return "services";
    }
}

