/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.dashboards;

import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.spi.DashboardPermissionService;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.portal.PortalPageManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;

public abstract class AbstractDashboardAdministration
extends JiraWebActionSupport {
    private PortalPage dashboard;
    private Long dashboardId;
    private final PermissionManager permissionManager;
    private final PortalPageManager portalPageManager;
    private final DashboardPermissionService permissionService;
    private String searchName;
    private String searchOwnerUserName;
    private String sortColumn;
    private String sortAscending;
    private String pagingOffset;
    private String totalResultCount;

    public AbstractDashboardAdministration(PermissionManager permissionManager, PortalPageManager portalPageManager) {
        this.permissionManager = permissionManager;
        this.portalPageManager = portalPageManager;
        this.permissionService = (DashboardPermissionService)ComponentAccessor.getOSGiComponentInstanceOfType(DashboardPermissionService.class);
    }

    protected PortalPage getDashboard() {
        if (this.dashboard == null && this.getDashboardId() != null) {
            this.dashboard = this.portalPageManager.getPortalPageById(this.getDashboardId());
        }
        return this.dashboard;
    }

    protected void setDashboard(PortalPage dashboard) {
        this.dashboard = dashboard;
    }

    public Long getDashboardId() {
        return this.dashboardId;
    }

    public void setDashboardId(Long dashboardId) {
        this.dashboardId = dashboardId;
    }

    public void setPageId(Long pageId) {
        this.dashboardId = pageId;
    }

    public String getDashboardName() throws GenericEntityException {
        if (!this.canUserAccessDashboard()) {
            this.addErrorMessage(this.getText("admin.errors.portalpages.no.access"));
            return null;
        }
        PortalPage dashboard = this.getDashboard();
        return dashboard == null ? null : dashboard.getName();
    }

    public String getPageName() throws Exception {
        return this.getDashboardName();
    }

    public Long getPageId() {
        return this.getDashboardId();
    }

    public String getSearchName() {
        return this.searchName;
    }

    public void setSearchName(String searchName) {
        this.searchName = searchName;
    }

    public String getSearchOwnerUserName() {
        return this.searchOwnerUserName;
    }

    public void setSearchOwnerUserName(String searchOwnerUserName) {
        this.searchOwnerUserName = searchOwnerUserName;
    }

    public String getSortColumn() {
        return this.sortColumn;
    }

    public void setSortColumn(String sortColumn) {
        this.sortColumn = sortColumn;
    }

    public String getSortAscending() {
        return this.sortAscending;
    }

    public void setSortAscending(String sortAscending) {
        this.sortAscending = sortAscending;
    }

    public String getPagingOffset() {
        return this.pagingOffset;
    }

    public void setPagingOffset(String pagingOffset) {
        this.pagingOffset = pagingOffset;
    }

    public String getTotalResultCount() {
        return this.totalResultCount;
    }

    public void setTotalResultCount(String totalResultCount) {
        this.totalResultCount = totalResultCount;
    }

    public boolean canUserAccessDashboard() {
        return this.permissionService.isReadableBy(DashboardId.valueOf((String)this.getDashboardId().toString()), this.getUsername());
    }

    private String getUsername() {
        ApplicationUser remoteUser = this.getLoggedInUser();
        if (remoteUser != null) {
            return remoteUser.getUsername();
        }
        return null;
    }

    protected String buildReturnUri() {
        StringBuilder url = new StringBuilder(this.getReturnUrl());
        url.append("?atl_token=").append(JiraUrlCodec.encode((String)this.getXsrfToken(), (String)"UTF-8"));
        if (StringUtils.isNotBlank((CharSequence)this.getSearchName())) {
            url.append("&searchName=").append(JiraUrlCodec.encode((String)this.getSearchName(), (String)"UTF-8"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getSearchOwnerUserName())) {
            url.append("&searchOwnerUserName=").append(JiraUrlCodec.encode((String)this.getSearchOwnerUserName(), (String)"UTF-8"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getSortColumn())) {
            url.append("&sortColumn=").append(JiraUrlCodec.encode((String)this.getSortColumn(), (String)"UTF-8"));
            url.append("&sortAscending=").append(JiraUrlCodec.encode((String)this.getSortAscending(), (String)"UTF-8"));
            url.append("&pagingOffset=").append(JiraUrlCodec.encode((String)this.getPagingOffset(), (String)"UTF-8"));
        }
        return url.toString();
    }

    protected JiraServiceContext getJiraServiceContext(String owner) {
        Object ctx = this.permissionManager.hasPermission(0, this.getLoggedInUser()) ? new JiraServiceContextImpl(UserUtils.getUser((String)owner)) : this.getJiraServiceContext();
        return ctx;
    }

    protected JiraServiceContext getJiraServiceContext(long id) {
        PortalPage dashboard = this.getDashboard(id);
        Object ctx = this.permissionManager.hasPermission(0, this.getLoggedInUser()) ? new JiraServiceContextImpl(dashboard.getOwner()) : this.getJiraServiceContext();
        return ctx;
    }

    private PortalPage getDashboard(long id) {
        return this.portalPageManager.getPortalPageById(Long.valueOf(id));
    }
}

