/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.importer.project;

import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.importer.project.ProjectImportBean;
import com.atlassian.jira.web.action.admin.importer.project.ProjectImportProgressTrackerUtil;
import com.atlassian.jira.web.bean.TaskDescriptorBean;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public abstract class AbstractProjectImportProgress<V extends Serializable>
extends JiraWebActionSupport {
    private static final long serialVersionUID = -3876535656531565166L;
    private String redirectOnComplete;
    private TaskDescriptorBean<V> ourTask;
    private final TaskManager taskManager;
    private final TaskDescriptorBean.Factory taskBeanFactory;
    private final ProjectImportProgressTrackerUtil progressTrackerUtil;

    public AbstractProjectImportProgress(TaskManager taskManager, TaskDescriptorBean.Factory factory, JiraPageBuilderService jiraPageBuilderService, ProjectImportProgressTrackerUtil projectImportProgressTrackerUtil) {
        this.taskManager = taskManager;
        this.taskBeanFactory = factory;
        this.progressTrackerUtil = projectImportProgressTrackerUtil;
        this.progressTrackerUtil.requireAuiProgressTrackerResource(jiraPageBuilderService);
    }

    public void doValidation() {
        Long taskId = ProjectImportBean.getProjectImportBeanFromSession().getTaskProgressInformation().getTaskId();
        TaskDescriptor descriptor = this.taskManager.getTask(taskId);
        if (taskId == null || descriptor == null) {
            if (!this.taskIsComplete()) {
                this.addErrorMessage(this.getText("admin.project.import.progress.no.task.id"));
            }
        } else {
            this.ourTask = this.taskBeanFactory.create(descriptor);
        }
    }

    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (this.ourTask == null && this.taskIsComplete()) {
            return this.getRedirect(this.getRedirectOnComplete());
        }
        if (this.ourTask.isFinished()) {
            return this.handleFinishedTask(this.ourTask);
        }
        return "input";
    }

    protected abstract boolean taskIsComplete();

    protected abstract String handleFinishedTask(TaskDescriptorBean<V> var1) throws ExecutionException, InterruptedException;

    protected abstract String getSubmitUrl();

    public String getRedirectOnComplete() {
        return this.redirectOnComplete;
    }

    public void setRedirectOnComplete(String redirectOnComplete) {
        this.redirectOnComplete = redirectOnComplete;
    }

    public TaskDescriptorBean<?> getOurTask() {
        return this.ourTask;
    }

    public abstract List<Map<String, Object>> getProgressTrackerSteps();

    protected List<Map<String, Object>> getProgressTrackerSteps(ProjectImportProgressTrackerUtil.Page page) {
        return this.progressTrackerUtil.getProgressTrackerSteps(page);
    }
}

