/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.importer.project;

import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;

public class ProjectImportProgressTrackerUtil {
    private final PluginAccessor pluginAccessor;
    private final I18nHelper i18n;

    public ProjectImportProgressTrackerUtil(PluginAccessor pluginAccessor, I18nHelper i18nHelper) {
        this.pluginAccessor = pluginAccessor;
        this.i18n = i18nHelper;
    }

    public List<Map<String, Object>> getProgressTrackerSteps(Page currentPage) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Page item : Page.values()) {
            builder.add((Object)MapBuilder.newBuilder().add((Object)"text", (Object)this.i18n.getText(item.getString())).add((Object)"isCurrent", (Object)(item == currentPage ? 1 : 0)).add((Object)"width", (Object)20).toMap());
        }
        return builder.build();
    }

    public void requireAuiProgressTrackerResource(JiraPageBuilderService jiraPageBuilderService) {
        WebResourceAssembler webResourceAssembler = jiraPageBuilderService.assembler();
        webResourceAssembler.resources().requireWebResource("com.atlassian.auiplugin:aui-progress-tracker");
    }

    public static enum Page {
        SELECT_BACKUP("admin.project.import.progress.tracker.select.backup"),
        SELECT_PROJECT("admin.project.import.progress.tracker.select.project"),
        IMPORT_VALIDATION("admin.project.import.progress.tracker.import.validation"),
        IMPORT_PROJECT("admin.project.import.progress.tracker.import.project"),
        SUMMARY("admin.project.import.progress.tracker.summary");

        private final String stringName;

        private Page(String name) {
            this.stringName = name;
        }

        public String getString() {
            return this.stringName;
        }
    }
}

