/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.screens;

import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.opensymphony.util.TextUtils;
import java.util.Collection;

public class AbstractFieldScreenAction
extends JiraWebActionSupport {
    protected final FieldScreenManager fieldScreenManager;
    private Long id;
    protected FieldScreen fieldScreen;
    private String fieldScreenName;
    private String fieldScreenDescription;

    public AbstractFieldScreenAction(FieldScreenManager fieldScreenManager) {
        this.fieldScreenManager = fieldScreenManager;
    }

    public Collection<FieldScreen> getFieldScreens() {
        return this.fieldScreenManager.getFieldScreens();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public FieldScreen getFieldScreen() {
        if (this.fieldScreen == null && this.getId() != null) {
            this.fieldScreen = this.fieldScreenManager.getFieldScreen(this.getId());
        }
        return this.fieldScreen;
    }

    public String getFieldScreenName() {
        return this.fieldScreenName;
    }

    public void setFieldScreenName(String fieldScreenName) {
        this.fieldScreenName = fieldScreenName;
    }

    public String getFieldScreenDescription() {
        return this.fieldScreenDescription;
    }

    public void setFieldScreenDescription(String fieldScreenDescription) {
        this.fieldScreenDescription = fieldScreenDescription;
    }

    protected void validateId() {
        if (this.getId() == null) {
            this.addErrorMessage(this.getText("admin.errors.id.cannot.be.null"));
        } else if (this.fieldScreenManager.getFieldScreen(this.getId()) == null) {
            this.addErrorMessage(this.getText("admin.errors.screens.screen.with.id.does.not.exist"));
        }
    }

    protected void validateScreenName() {
        if (!TextUtils.stringSet((String)this.getFieldScreenName())) {
            this.addError("fieldScreenName", this.getText("admin.common.errors.validname"));
        } else if (this.getFieldScreen() == null || !this.getFieldScreenName().equals(this.getFieldScreen().getName())) {
            for (FieldScreen fieldScreen : this.getFieldScreens()) {
                if (!this.getFieldScreenName().equals(fieldScreen.getName()) || this.getFieldScreen() != null && fieldScreen.getId().equals(this.getId())) continue;
                this.addError("fieldScreenName", this.getText("admin.errors.screens.duplicate.screen.name"));
            }
        }
    }

    protected String redirectToView() {
        return this.returnCompleteWithInlineRedirect("ViewFieldScreens.jspa");
    }

    protected FieldScreenManager getFieldScreenManager() {
        return this.fieldScreenManager;
    }
}

