/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.screens;

import com.atlassian.jira.auditing.handlers.FieldScreenSchemeHandler;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.issuetype.ProjectIssueTypeScreenSchemeHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.issuefields.screens.AbstractFieldScreenSchemeItemAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.List;

@WebSudoRequired
public class ConfigureFieldScreenScheme
extends AbstractFieldScreenSchemeItemAction {
    private final ProjectIssueTypeScreenSchemeHelper helper;
    private List<Project> projects;
    private final FieldScreenSchemeHandler fieldScreenSchemeHandler;

    public ConfigureFieldScreenScheme(FieldScreenSchemeManager fieldScreenSchemeManager, FieldScreenManager fieldScreenManager, ProjectIssueTypeScreenSchemeHelper helper, FieldScreenSchemeHandler fieldScreenSchemeHandler) {
        super(fieldScreenSchemeManager, fieldScreenManager);
        this.helper = helper;
        this.fieldScreenSchemeHandler = fieldScreenSchemeHandler;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    protected void doValidation() {
        this.validateId();
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        return this.getResult();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doDeleteFieldScreenSchemeItem() {
        this.validateIssueOperationId();
        if (!this.invalidInput()) {
            FieldScreenScheme fieldScreenScheme = this.getFieldScreenScheme();
            FieldScreenSchemeItem removedItem = fieldScreenScheme.removeFieldScreenSchemeItem(this.getIssueOperation());
            this.fieldScreenSchemeHandler.handleFieldScreenSchemeItemDeleted(fieldScreenScheme, removedItem);
            return this.redirectToView();
        }
        return this.getResult();
    }

    public List<Project> getUsedIn() {
        if (this.projects == null) {
            FieldScreenScheme fieldScreenScheme = this.getFieldScreenScheme();
            this.projects = this.helper.getProjectsForFieldScreenScheme(fieldScreenScheme);
        }
        return this.projects;
    }
}

