/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.screens;

import com.atlassian.jira.auditing.handlers.FieldScreenSchemeHandler;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.issuefields.screens.AbstractFieldScreenSchemeItemAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;

@WebSudoRequired
public class EditFieldScreenSchemeItem
extends AbstractFieldScreenSchemeItemAction {
    private final FieldScreenSchemeHandler fieldScreenSchemeHandler;

    public EditFieldScreenSchemeItem(FieldScreenSchemeManager fieldScreenSchemeManager, FieldScreenManager fieldScreenManager, FieldScreenSchemeHandler fieldScreenSchemeHandler) {
        super(fieldScreenSchemeManager, fieldScreenManager);
        this.fieldScreenSchemeHandler = fieldScreenSchemeHandler;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        this.validateIssueOperationId();
        if (!this.invalidInput()) {
            FieldScreenSchemeItem fieldScreenSchemeItem = this.getFieldScreenScheme().getFieldScreenSchemeItem(this.getIssueOperation());
            this.setFieldScreenId(fieldScreenSchemeItem.getFieldScreen().getId());
            return "input";
        }
        return this.getResult();
    }

    protected void doValidation() {
        this.validateIssueOperationId();
        if (!this.invalidInput()) {
            this.validateFieldScreenId();
        }
    }

    @Override
    protected void validateIssueOperationId() {
        super.validateIssueOperationId();
        if (!this.invalidInput() && this.getFieldScreenScheme().getFieldScreenSchemeItem(this.getIssueOperation()) == null) {
            this.addErrorMessage(this.getText("admin.errors.screens.no.scheme.item.exists.with.id", "'" + this.getIssueOperationId() + "'"));
        }
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        FieldScreenScheme fieldScreenScheme = this.getFieldScreenScheme();
        FieldScreenSchemeItem fieldScreenSchemeItem = fieldScreenScheme.getFieldScreenSchemeItem(this.getIssueOperation());
        FieldScreen oldScreen = fieldScreenSchemeItem.getFieldScreen();
        fieldScreenSchemeItem.setFieldScreen(this.getFieldScreenManager().getFieldScreen(this.getFieldScreenId()));
        fieldScreenSchemeItem.store();
        this.fieldScreenSchemeHandler.handleFieldScreenSchemeItemUpdated(fieldScreenScheme, fieldScreenSchemeItem, oldScreen);
        return this.redirectToView();
    }
}

