/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.priorities;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.PrioritySchemeService;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.issue.fields.option.IssueConstantAUIOption;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.priority.PrioritySchemeHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraArrayUtils;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.ActionViewDataMappings;
import com.atlassian.jira.web.action.admin.priorities.AbstractManagePrioritiesAction;
import com.atlassian.jira.web.action.admin.priorities.PriorityManageableOption;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public abstract class ConfigurePriorityScheme
extends AbstractManagePrioritiesAction {
    protected final PriorityManager priorityManager;
    protected final PageBuilderService pageBuilder;
    protected final I18nHelper i18nHelper;
    protected PrioritySchemeHelper prioritySchemeHelper;
    protected String name;
    protected String description;
    protected String defaultPriority;
    protected String[] selectedPriorities;
    protected List<Project> projectsForScheme;
    protected static final String[] NO_PRIORITIES = new String[0];

    public ConfigurePriorityScheme(FieldConfigSchemeManager configSchemeManager, FieldManager fieldManager, PriorityManageableOption priorityManageableOption, PrioritySchemeManager prioritySchemeManager, PriorityManager priorityManager, PageBuilderService pageBuilder, PrioritySchemeService prioritySchemeService, I18nHelper i18nHelper, PrioritySchemeHelper prioritySchemeHelper) {
        super(configSchemeManager, fieldManager, priorityManageableOption, prioritySchemeManager, prioritySchemeService);
        this.priorityManager = priorityManager;
        this.pageBuilder = pageBuilder;
        this.i18nHelper = i18nHelper;
        this.prioritySchemeHelper = prioritySchemeHelper;
    }

    protected void processResources() {
        this.pageBuilder.assembler().resources().requireWebResource("jira.webresources:configure-priority-scheme");
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        this.processResources();
        if (this.getHasErrorMessages()) {
            return "error";
        }
        return super.doDefault();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        return this.getRedirect();
    }

    protected void doValidation() {
        this.processResources();
        ServiceResult validate = this.prioritySchemeService.schemeDataValidate(this.getLoggedInUser(), PrioritySchemeService.PrioritySchemeData.builder().id(this.getSchemeId()).name(this.getName()).description(this.getDescription()).priorityIds(Optional.ofNullable(this.selectedPriorities).map(Arrays::asList).orElse(Collections.emptyList())).defaultPriorityId(this.getDefaultPriority()).build());
        if (!validate.isValid()) {
            this.addErrorCollection(validate.getErrorCollection());
        }
    }

    public Collection<Priority> getAllPriorities() {
        List priorities = this.priorityManager.getPriorities();
        if (priorities == null) {
            return new ArrayList<Priority>();
        }
        return priorities;
    }

    @ActionViewData
    public long getMaxHeight() {
        Collection<Priority> allPriorities = this.getAllPriorities();
        return Math.max(1, allPriorities.size()) * 23;
    }

    @ActionViewData
    public String getTitle() {
        return this.getManageableOption().getTitle();
    }

    @ActionViewData
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ActionViewData
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ActionViewData
    public String getDefaultPriority() {
        return this.defaultPriority;
    }

    public void setDefaultPriority(String defaultPriority) {
        this.defaultPriority = defaultPriority;
    }

    public String[] getSelectedPriorities() {
        return this.selectedPriorities;
    }

    public void setSelectedPriorities(Collection<Priority> selectedPriorities) {
        this.setSelectedPriorities(selectedPriorities.stream().map(IssueConstant::getId).collect(Collectors.toList()));
    }

    public void setSelectedPriorities(List<String> selectedPriorities) {
        this.setSelectedPriorities(selectedPriorities.stream().filter(Objects::nonNull).collect(Collectors.toList()).toArray(new String[0]));
    }

    public void setSelectedPriorities(String[] selectedPriorities) {
        this.selectedPriorities = JiraArrayUtils.isContainsOneBlank(selectedPriorities) ? NO_PRIORITIES : selectedPriorities;
    }

    @ActionViewData
    public List<Project> getProjectsForScheme() {
        FieldConfigScheme configScheme = this.getConfigScheme();
        if (configScheme != null) {
            this.projectsForScheme = this.prioritySchemeHelper.getProjectsForScheme(configScheme);
        }
        return this.projectsForScheme;
    }

    protected Collection<Priority> getPrioritiesInScheme() {
        return this.prioritySchemeManager.getPrioritiesFromIds((Collection)this.prioritySchemeManager.getOptions(this.getConfig()));
    }

    protected Collection getPrioritiesNotSelected() {
        Collection<Priority> allPriorities = this.getAllPriorities();
        String[] selectedPriorities = this.getSelectedPriorities();
        if (selectedPriorities != null) {
            return CollectionUtils.subtract(allPriorities, this.toPrioritiesList(selectedPriorities));
        }
        return allPriorities;
    }

    protected Collection<Priority> toPrioritiesList(String[] prioritiesIds) {
        if (prioritiesIds != null) {
            return this.prioritySchemeManager.getPrioritiesFromIds(Arrays.asList(prioritiesIds));
        }
        return Collections.emptyList();
    }

    protected Collection<IssueConstantAUIOption> toAUIOptions(Collection<Priority> priorities) {
        return this.toAUIOptions(priorities, true);
    }

    protected Collection<IssueConstantAUIOption> toAUIOptions(Collection<Priority> priorities, boolean includeEmptyValue) {
        ArrayList<IssueConstantAUIOption> priorityOptions = new ArrayList<IssueConstantAUIOption>();
        if (includeEmptyValue) {
            priorityOptions.add(new IssueConstantAUIOption(this.i18nHelper.getText("common.words.none"), ""));
        }
        priorityOptions.addAll(priorities.stream().map(priority -> new IssueConstantAUIOption(priority.getName(), priority.getId())).collect(Collectors.toList()));
        return priorityOptions;
    }

    protected FieldConfig getConfig() {
        return this.prioritySchemeManager.getFieldConfigForDefaultMapping(this.getConfigScheme());
    }

    @ActionViewDataMappings(value={"success", "input", "error"})
    public Map<String, Object> getSoyData() {
        ImmutableMap.Builder data = new ImmutableMap.Builder().put((Object)"xsrfToken", (Object)this.getXsrfToken()).put((Object)"fieldErrors", (Object)this.getErrors()).put((Object)"globalErrors", (Object)this.getErrorMessages()).put((Object)"operation", (Object)this.getActionName()).put((Object)"allPriorities", this.toAUIOptions(this.getAllPriorities())).put((Object)"selectedPriorities", this.toPrioritiesList(this.getSelectedPriorities())).put((Object)"availablePriorities", (Object)this.getPrioritiesNotSelected());
        return data.build();
    }
}

