/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.group.GroupService;
import com.atlassian.jira.bc.issue.worklog.TimeTrackingConfiguration;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.subscription.FilterSubscription;
import com.atlassian.jira.issue.subscription.SubscriptionManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.web.action.IssueActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ofbiz.core.entity.GenericEntityException;

@WebSudoRequired
public class DeleteGroup
extends IssueActionSupport {
    private String name;
    private String swapGroup;
    private boolean confirm;
    private List<ApplicationRole> applicationsForGroup;
    private Integer numberOfAffectedUsers;
    private Group group;
    private final SubscriptionManager subscriptionManager;
    private final SearchRequestService searchRequestService;
    private final GroupService groupService;
    private final GroupManager groupManager;
    private final ApplicationRoleManager roleManager;

    public DeleteGroup(IssueManager issueManager, CustomFieldManager customFieldManager, AttachmentManager attachmentManager, ProjectManager projectManager, PermissionManager permissionManager, VersionManager versionManager, SubscriptionManager subscriptionManager, SearchRequestService searchRequestService, GroupService groupService, UserIssueHistoryManager userHistoryManager, TimeTrackingConfiguration timeTrackingConfiguration, GroupManager groupManager, ApplicationRoleManager roleManager) {
        super(issueManager, customFieldManager, attachmentManager, projectManager, permissionManager, versionManager, userHistoryManager, timeTrackingConfiguration);
        this.subscriptionManager = subscriptionManager;
        this.searchRequestService = searchRequestService;
        this.groupService = groupService;
        this.groupManager = groupManager;
        this.roleManager = roleManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        this.groupService.isAdminDeletingSysAdminGroup(this.getJiraServiceContext(), this.name);
        this.groupService.areOnlyGroupsGrantingUserAdminPermissions(this.getJiraServiceContext(), (Collection)ImmutableList.of((Object)this.name));
        return super.doDefault();
    }

    protected void doValidation() {
        this.groupService.validateDelete(this.getJiraServiceContext(), this.name, this.swapGroup);
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (this.confirm) {
            this.groupService.delete(this.getJiraServiceContext(), this.name, this.swapGroup);
        }
        if (this.getHasErrorMessages()) {
            return "error";
        }
        return this.getRedirect("GroupBrowser.jspa");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }

    public String getSwapGroup() {
        return this.swapGroup;
    }

    public void setSwapGroup(String swapGroup) {
        this.swapGroup = swapGroup;
    }

    public long getMatchingCommentsAndWorklogsCount() throws GenericEntityException {
        return this.groupService.getCommentsAndWorklogsGuardedByGroupCount(this.name);
    }

    public Collection getOtherGroups() {
        ArrayList<String> otherGroups = new ArrayList<String>();
        try {
            Collection groups = this.groupManager.getAllGroups();
            for (Group group : groups) {
                if (group.getName().equals(this.name)) continue;
                otherGroups.add(group.getName());
            }
        }
        catch (Exception e) {
            this.addErrorMessage(this.getText("admin.errors.groups.error.occured.getting.other.groups"));
        }
        return otherGroups;
    }

    public boolean hasSubscriptions() {
        try {
            List subList = this.subscriptionManager.getAllFilterSubscriptions();
            for (FilterSubscription subscription : subList) {
                if (!this.name.equals(subscription.getGroupName())) continue;
                return true;
            }
        }
        catch (DataAccessException e) {
            this.log.error((Object)e, (Throwable)e);
        }
        return false;
    }

    public Collection<String> getSubscriptions() {
        try {
            List subList = this.subscriptionManager.getAllFilterSubscriptions();
            ArrayList<String> subscriptions = new ArrayList<String>();
            for (FilterSubscription subscription : subList) {
                if (!this.name.equals(subscription.getGroupName())) continue;
                String userkey = subscription.getUserKey();
                Long filterID = subscription.getFilterId();
                ApplicationUser user = this.getUserManager().getUserByKey(userkey);
                JiraServiceContextImpl ctx = new JiraServiceContextImpl(user);
                SearchRequest request = this.searchRequestService.getFilter((JiraServiceContext)ctx, filterID);
                if (request == null) continue;
                String filterName = request.getName();
                String username = user == null ? null : user.getUsername();
                String text = this.getText("admin.deletegroup.subscriptions.item", filterName, username);
                subscriptions.add(text);
            }
            return subscriptions;
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            return Collections.emptyList();
        }
    }

    public boolean isAssociatedToAnyApplication() {
        return !this.getRolesForGroup().isEmpty();
    }

    public List<ApplicationRole> getRolesForGroup() {
        if (this.applicationsForGroup != null) {
            return this.applicationsForGroup;
        }
        assert (this.name != null && this.name.length() > 0) : "expected name to be set by params: " + this.name;
        Group groupToDelete = this.getGroup();
        if (groupToDelete == null) {
            this.applicationsForGroup = ImmutableList.of();
            return this.applicationsForGroup;
        }
        this.applicationsForGroup = Ordering.natural().onResultOf(ApplicationRole::getName).immutableSortedCopy((Iterable)this.roleManager.getRolesForGroup(groupToDelete));
        return this.applicationsForGroup;
    }

    public Integer getApplicationUsersAffected() {
        if (this.numberOfAffectedUsers != null) {
            return this.numberOfAffectedUsers;
        }
        Group groupBeingRemoved = this.getGroup();
        if (this.group == null) {
            this.numberOfAffectedUsers = 0;
            return this.numberOfAffectedUsers;
        }
        HashSet usersLosingRoles = Sets.newHashSet();
        HashSet usersInDeletionGroup = Sets.newHashSet((Iterable)this.groupManager.getUsersInGroup(groupBeingRemoved));
        for (ApplicationRole role : this.getRolesForGroup()) {
            Set groupsForRole = role.getGroups();
            if (groupsForRole.size() > 1) {
                HashSet users = Sets.newHashSet((Iterable)usersInDeletionGroup);
                for (Group group : groupsForRole) {
                    if (group.equals((Object)groupBeingRemoved)) continue;
                    users.removeAll(this.groupManager.getUsersInGroup(group));
                }
                usersLosingRoles.addAll(users);
                continue;
            }
            usersLosingRoles.addAll(usersInDeletionGroup);
        }
        this.numberOfAffectedUsers = usersLosingRoles.size();
        return this.numberOfAffectedUsers;
    }

    private Group getGroup() {
        if (this.group != null) {
            return this.group;
        }
        this.group = this.groupManager.getGroup(this.getName());
        return this.group;
    }
}

