/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.jira.crowd.embedded.JaacsService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.ValidationFailureException;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

@WebSudoRequired
public class EditCrowdApplication
extends JiraWebActionSupport {
    static final String ACTION_NAME = "EditCrowdApplication";
    private static final String EDITSCREEN = "editscreen";
    private static final String CFG_CROWD_SERVER = "ConfigureCrowdServer.jspa";
    public static final String REMOTE_ADDR_SEP = "\r\n";
    private final JaacsService jaacsService;
    private final I18nHelper.BeanFactory i18nFactory;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private Long id;
    private String name;
    private String credential;
    private String remoteAddresses = "127.0.0.1\n::1";

    public EditCrowdApplication(JaacsService jaacsService, I18nHelper.BeanFactory i18nFactory, JiraAuthenticationContext jiraAuthenticationContext) {
        this.jaacsService = jaacsService;
        this.i18nFactory = i18nFactory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        if (this.id != null) {
            ApplicationImpl application = this.jaacsService.findById(this.getLoggedInUser(), this.id);
            if (application == null) {
                return this.redirect(CFG_CROWD_SERVER, new String[0]);
            }
            this.name = application.getName();
            this.credential = null;
            this.remoteAddresses = this.stringify(application.getRemoteAddresses());
        }
        return EDITSCREEN;
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doCreate() {
        ApplicationImpl application = ApplicationImpl.newInstanceWithPassword((String)this.name, (ApplicationType)ApplicationType.GENERIC_APPLICATION, (String)this.credential);
        application.setRemoteAddresses(this.remoteAddressify(this.remoteAddresses));
        application.setType(ApplicationType.GENERIC_APPLICATION);
        try {
            this.jaacsService.create(this.getLoggedInUser(), (Application)application);
            return this.redirect(CFG_CROWD_SERVER, "success", this.i18n().getText("admin.jaacs.application.application.created", this.name));
        }
        catch (ValidationFailureException e) {
            this.addErrorCollection(e.errors());
            return EDITSCREEN;
        }
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doUpdate() {
        if (this.id != null) {
            ApplicationImpl application = this.jaacsService.findById(this.getLoggedInUser(), this.id);
            if (application == null) {
                return this.redirect(CFG_CROWD_SERVER, new String[0]);
            }
            application.setName(this.name);
            application.setRemoteAddresses(this.remoteAddressify(this.remoteAddresses));
            try {
                this.jaacsService.update(this.getLoggedInUser(), (Application)application);
                if (!StringUtils.isBlank((CharSequence)this.credential) && !this.jaacsService.resetPassword(this.getJiraServiceContext(), this.credential, this.id)) {
                    return EDITSCREEN;
                }
                return this.redirect(CFG_CROWD_SERVER, "success", this.i18n().getText("admin.jaacs.application.application.updated", this.name));
            }
            catch (ValidationFailureException e) {
                this.addErrorCollection(e.errors());
            }
        }
        return EDITSCREEN;
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doDelete() throws Exception {
        if (this.jaacsService.validateDeleteApplication(this.getJiraServiceContext(), this.id)) {
            ApplicationImpl application = this.jaacsService.findById(this.getLoggedInUser(), this.id);
            if (this.jaacsService.deleteApplication(this.getJiraServiceContext(), this.id)) {
                return this.redirect(CFG_CROWD_SERVER, "success", this.i18n().getText("admin.jaacs.application.application.deleted", application.getName()));
            }
        }
        return this.redirect(CFG_CROWD_SERVER, new String[0]);
    }

    public String getTitleTextKey() {
        return this.isCreate() ? "admin.jaacs.application.create.title" : "admin.jaacs.application.edit.title";
    }

    public String getPasswordDescriptionKey() {
        return this.isCreate() ? "admin.jaacs.application.password.description.add" : "admin.jaacs.application.password.description.edit";
    }

    public String getHelpTextKey() {
        return this.isCreate() ? "admin.jaacs.application.create.description" : "admin.jaacs.application.edit.description";
    }

    public String getSubmitAction() {
        return String.format("%s!%s.jspa", ACTION_NAME, this.isCreate() ? "create" : "update");
    }

    public String getCancelAction() {
        return CFG_CROWD_SERVER;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCredential(String credential) {
        this.credential = credential;
    }

    public String getRemoteAddresses() {
        return this.remoteAddresses;
    }

    public void setRemoteAddresses(String remoteAddresses) {
        this.remoteAddresses = remoteAddresses;
    }

    protected boolean isCreate() {
        return this.id == null;
    }

    protected String redirect(String defaultUrl, String ... params) {
        String paramString = "";
        if (params.length > 0) {
            StringBuilder builder = new StringBuilder("?");
            try {
                for (int i = 0; i < params.length; ++i) {
                    if (i % 2 != 0) {
                        builder.append("=");
                    }
                    builder.append(URLEncoder.encode(params[i], "UTF-8"));
                    paramString = builder.toString();
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        this.getRedirect(String.format("%s%s", defaultUrl, paramString));
        return null;
    }

    protected I18nHelper i18n() {
        return this.i18nFactory.getInstance(this.jiraAuthenticationContext.getUser());
    }

    protected String stringify(Set<RemoteAddress> remoteAddresses) {
        return StringUtils.join((Iterable)Iterables.transform(remoteAddresses, (Function)new StringifyFn()), (String)REMOTE_ADDR_SEP);
    }

    protected Set<RemoteAddress> remoteAddressify(String stringifiedRemoteAddresses) {
        List<String> remoteAddresses = Arrays.asList(StringUtils.split((String)stringifiedRemoteAddresses, (String)REMOTE_ADDR_SEP));
        return Sets.newHashSet((Iterable)Iterables.transform(remoteAddresses, (Function)new RemoteAddressifyFn()));
    }

    protected static class StringifyFn
    implements Function<RemoteAddress, String> {
        protected StringifyFn() {
        }

        public String apply(@Nullable RemoteAddress remoteAddress) {
            return remoteAddress.getAddress();
        }
    }

    protected static class RemoteAddressifyFn
    implements Function<String, RemoteAddress> {
        protected RemoteAddressifyFn() {
        }

        public RemoteAddress apply(@Nullable String address) {
            return new RemoteAddress(address);
        }
    }
}

