/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow.scheme;

import com.atlassian.jira.scheme.AbstractDeleteScheme;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.SchemeIsBeingMigratedException;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.migration.WorkflowSchemeMigrationTaskAccessor;
import com.atlassian.sal.api.websudo.WebSudoRequired;

@WebSudoRequired
public class DeleteScheme
extends AbstractDeleteScheme {
    private final WorkflowSchemeManager workflowSchemeManager;
    private final WorkflowSchemeMigrationTaskAccessor taskAccessor;

    public DeleteScheme(WorkflowSchemeManager workflowSchemeManager, WorkflowSchemeMigrationTaskAccessor taskAccessor) {
        this.workflowSchemeManager = workflowSchemeManager;
        this.taskAccessor = taskAccessor;
    }

    @Override
    public SchemeManager getSchemeManager() {
        return this.workflowSchemeManager;
    }

    @Override
    public String getRedirectURL() {
        return "ViewWorkflowSchemes.jspa";
    }

    @Override
    protected void doValidation() {
        super.doValidation();
        AssignableWorkflowScheme workflowScheme = this.workflowSchemeManager.getWorkflowSchemeObj(this.getSchemeId().longValue());
        if (workflowScheme != null && this.taskAccessor.getActive((WorkflowScheme)workflowScheme) != null) {
            this.addMigrationError();
        }
    }

    @Override
    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        try {
            return super.doExecute();
        }
        catch (SchemeIsBeingMigratedException e) {
            this.addMigrationError();
            return "error";
        }
    }

    private void addMigrationError() {
        this.addErrorMessage(this.getText("admin.errors.deletescheme.cannot.delete.while.migrating"));
    }
}

