/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.browser;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;

public class ProjectDataForArchivingCollector
extends SimpleCollector {
    private static final Long NULL_DATE_IN_LUCENE = Long.MAX_VALUE;
    private final Map<Long, Long> projectToUpdatedDate = new HashMap<Long, Long>();
    private final Map<Long, Long> projectToIssueCount = new HashMap<Long, Long>();
    private SortedDocValues docIdToProjectIdValues;
    private NumericDocValues docIdToUpdatedDateValues;

    public void setScorer(Scorer scorer) {
    }

    public void collect(int docId) throws IOException {
        Long updatedDate;
        this.docIdToProjectIdValues.advanceExact(docId);
        long projectId = Long.parseLong(this.docIdToProjectIdValues.binaryValue().utf8ToString());
        if (this.docIdToUpdatedDateValues.advanceExact(docId) && !NULL_DATE_IN_LUCENE.equals(updatedDate = Long.valueOf(this.docIdToUpdatedDateValues.longValue()))) {
            this.projectToUpdatedDate.merge(projectId, updatedDate, this::getLatest);
        }
        this.projectToIssueCount.merge(projectId, 1L, Long::sum);
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docIdToProjectIdValues = context.reader().getSortedDocValues("projid");
        this.docIdToUpdatedDateValues = context.reader().getNumericDocValues("sort_updated");
    }

    Map<Long, Long> getMapToUpdatedDate() {
        return this.projectToUpdatedDate.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Long)e.getValue()));
    }

    Map<Long, Long> getMapToIssueCount() {
        return this.projectToIssueCount;
    }

    private Long getLatest(Long first, Long second) {
        return first >= second ? first : second;
    }

    public boolean needsScores() {
        return false;
    }
}

