/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.browser;

import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.VersionProxy;
import com.atlassian.jira.project.util.ReleaseNoteManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.google.common.base.Optional;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.ofbiz.core.entity.GenericEntityException;
import webwork.action.Action;

public class ReleaseNote
extends JiraWebActionSupport {
    private static final String SECURITY_BREACH = "securitybreach";
    private long projectId;
    private String styleName;
    private String version;
    private Optional<Project> project;
    private final ProjectManager projectManager;
    private final ProjectService projectService;
    private final ReleaseNoteManager releaseNoteManager;
    private final ConstantsManager constantsManager;
    private final VersionManager versionManager;

    public ReleaseNote(ProjectManager projectManager, ProjectService projectService, ReleaseNoteManager releaseNoteManager, ConstantsManager constantsManager, VersionManager versionManager) {
        this.projectManager = projectManager;
        this.projectService = projectService;
        this.releaseNoteManager = releaseNoteManager;
        this.constantsManager = constantsManager;
        this.versionManager = versionManager;
    }

    public Collection getVersions() throws GenericEntityException {
        Optional<Project> project = this.getProject();
        if (!project.isPresent()) {
            return Collections.emptyList();
        }
        ArrayList<VersionProxy> unreleased = new ArrayList<VersionProxy>();
        Iterator unreleasedIter = this.versionManager.getVersionsUnreleased(((Project)project.get()).getId(), false).iterator();
        if (unreleasedIter.hasNext()) {
            unreleased.add(new VersionProxy(-2L, this.getText("common.filters.unreleasedversions")));
            while (unreleasedIter.hasNext()) {
                unreleased.add(new VersionProxy((Version)unreleasedIter.next()));
            }
        }
        ArrayList<VersionProxy> released = new ArrayList<VersionProxy>();
        ArrayList releasedIter = new ArrayList(this.versionManager.getVersionsReleased(((Project)project.get()).getId(), false));
        if (!releasedIter.isEmpty()) {
            released.add(new VersionProxy(-3L, this.getText("common.filters.releasedversions")));
            Collections.reverse(releasedIter);
            for (Version aReleasedIter : releasedIter) {
                released.add(new VersionProxy(aReleasedIter));
            }
        }
        ArrayList<VersionProxy> versions = new ArrayList<VersionProxy>();
        versions.addAll(unreleased);
        versions.addAll(released);
        return versions;
    }

    public Collection getStyleNames() {
        return this.releaseNoteManager.getStyles().keySet();
    }

    public String getReleaseNote() {
        return this.releaseNoteManager.getReleaseNote((Action)this, this.getStyleName(), this.getSelectedVersion(), this.getLoggedInUser(), (Project)this.getProject().orNull());
    }

    public void setProjectId(long projectId) {
        this.projectId = projectId;
    }

    public void setProjectName(String projectName) {
        Project project = this.projectManager.getProjectObjByName(projectName);
        if (project != null) {
            this.projectId = project.getId();
        }
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setVersionName(String versionName) {
        Version versionObj = this.versionManager.getVersion(Long.valueOf(this.getProjectId()), versionName);
        if (versionObj != null) {
            this.version = "" + versionObj.getId();
        }
    }

    public void setStyleName(String styleName) {
        this.styleName = styleName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getStyleName() {
        return this.styleName;
    }

    public long getProjectId() {
        return this.projectId;
    }

    protected void doValidation() {
        if (!TextUtils.stringSet((String)this.version) || "-1".equals(this.version) || "-2".equals(this.version) || "-3".equals(this.version)) {
            this.addError("version", this.getText("releasenotes.version.select"));
        } else if (this.getSelectedVersion() == null) {
            this.addError("version", this.getText("releasenotes.version.error"));
        }
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws GenericEntityException {
        if (!this.getProject().isPresent()) {
            return SECURITY_BREACH;
        }
        return this.getResult();
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doConfigure() throws GenericEntityException {
        if (!this.getProject().isPresent()) {
            return SECURITY_BREACH;
        }
        if (this.getVersions().isEmpty() || this.getStyleNames().isEmpty()) {
            return "error";
        }
        return "success";
    }

    private Version getSelectedVersion() {
        try {
            return this.versionManager.getVersion(Long.valueOf(Long.parseLong(this.getVersion())));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Optional<Project> getProject() {
        if (this.project == null) {
            ProjectService.GetProjectResult result = this.projectService.getProjectByIdForAction(this.getLoggedInApplicationUser(), Long.valueOf(this.projectId), ProjectAction.VIEW_PROJECT);
            this.project = Optional.fromNullable((Object)result.getProject());
        }
        return this.project;
    }

    public Collection<IssueType> getIssueTypes() throws GenericEntityException {
        return this.constantsManager.getRegularIssueTypeObjects();
    }
}

