/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.favourites;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.SharedEntityAccessor;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import org.apache.commons.lang3.StringUtils;

public class AdjustFavourite
extends JiraWebActionSupport {
    private final FavouritesService favouritesService;
    private final SharedEntityAccessor.Factory sharedEntityAccessorFactory;
    private Long entityId = null;
    private String entityType = null;
    private String redirectUrl = null;

    public AdjustFavourite(FavouritesService favouritesService, SharedEntityAccessor.Factory sharedEntityAccessorFactory) {
        Assertions.notNull((String)"favouritesService", (Object)favouritesService);
        Assertions.notNull((String)"sharedEntityAccessorFactory", (Object)sharedEntityAccessorFactory);
        this.sharedEntityAccessorFactory = sharedEntityAccessorFactory;
        this.favouritesService = favouritesService;
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doAdd() throws Exception {
        if (this.getLoggedInUser() != null) {
            if (this.entityId == null) {
                this.addErrorMessage(this.getText("favourite.adjust.no.id.specified"));
                return "error";
            }
            JiraServiceContext serviceContext = this.getJiraServiceContext();
            SharedEntity sharedEntity = this.getSharedEntity();
            if (this.hasAnyErrors() || sharedEntity == null) {
                return "error";
            }
            this.favouritesService.addFavourite(serviceContext, sharedEntity);
            if (this.hasAnyErrors()) {
                return "error";
            }
        }
        return this.redirect();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doRemove() throws Exception {
        if (this.getLoggedInUser() != null) {
            if (this.entityId == null) {
                this.addErrorMessage(this.getText("favourite.adjust.no.id.specified"));
                return "error";
            }
            JiraServiceContext serviceContext = this.getJiraServiceContext();
            SharedEntity sharedEntity = this.getSharedEntity();
            if (this.hasAnyErrors() || sharedEntity == null) {
                return "error";
            }
            this.favouritesService.removeFavourite(serviceContext, sharedEntity);
            if (this.hasAnyErrors()) {
                return "error";
            }
        }
        return this.redirect();
    }

    private SharedEntity getSharedEntity() {
        SharedEntity entity = null;
        if (StringUtils.isBlank((CharSequence)this.entityType)) {
            this.addErrorMessage(this.getText("favourite.adjust.no.type.specified"));
        } else {
            SharedEntityAccessor accessor = this.sharedEntityAccessorFactory.getSharedEntityAccessor(this.entityType);
            if (accessor == null) {
                this.addErrorMessage(this.getText("favourite.adjust.invalid.type.specified", this.entityType));
            } else {
                entity = accessor.getSharedEntity(this.getLoggedInUser(), this.entityId);
                if (entity == null) {
                    this.addErrorMessage(this.getText("favourite.adjust.no.entity.found"));
                }
            }
        }
        return entity;
    }

    private String redirect() {
        if (StringUtils.isEmpty((CharSequence)this.redirectUrl)) {
            return this.getRedirect("MyJiraHome.jspa");
        }
        return this.getRedirect(this.redirectUrl);
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }
}

