/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.history;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.util.json.JSONEscaper;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RecentIssueHistory
extends JiraWebActionSupport {
    private boolean json;
    private final UserIssueHistoryManager userHistoryManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public RecentIssueHistory(UserIssueHistoryManager userHistoryManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this.userHistoryManager = userHistoryManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        return super.doExecute();
    }

    public boolean isJson() {
        return this.json;
    }

    public void setJson(boolean json) {
        this.json = json;
    }

    public Collection<IssueHistoryBean> getHistoryItems() {
        ArrayList<IssueHistoryBean> recentHistory = new ArrayList<IssueHistoryBean>();
        List history = this.userHistoryManager.getShortIssueHistory(this.jiraAuthenticationContext.getUser());
        for (Issue issue : history) {
            recentHistory.add(new IssueHistoryBean(issue.getKey(), issue.getSummary()));
        }
        return recentHistory;
    }

    public String jsonEscape(String jsonStr) {
        return JSONEscaper.escape((String)jsonStr);
    }

    public static class IssueHistoryBean {
        private final String issueKey;
        private final String summary;
        private final String shortSummary;

        public IssueHistoryBean(String issueKey, String summary) {
            this.issueKey = issueKey;
            this.shortSummary = this.summary = summary;
        }

        public String getIssueKey() {
            return this.issueKey;
        }

        public String getSummary() {
            return this.summary;
        }

        public String getShortSummary() {
            return this.shortSummary;
        }
    }
}

