/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.web.action.JiraWebActionSupport;

public class CantBrowseCreatedIssue
extends JiraWebActionSupport {
    private String issueKey;
    private boolean converted;
    private final IssueManager issueManager;
    private final UserManager userManager;
    private static final String CONVERTED = "converted";

    public CantBrowseCreatedIssue(IssueManager issueManager, UserManager userManager) {
        this.issueManager = issueManager;
        this.userManager = userManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        MutableIssue issue = this.issueManager.getIssueObject(this.issueKey);
        if (issue != null && ComponentAccessor.getPermissionManager().hasPermission(10, (Issue)issue, this.getLoggedInUser())) {
            return this.getRedirect("/browse/" + this.issueKey);
        }
        if (!this.converted) {
            return super.doExecute();
        }
        return CONVERTED;
    }

    public boolean isConverted() {
        return this.converted;
    }

    public void setConverted(boolean converted) {
        this.converted = converted;
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    public void setIssueKey(String issueKey) {
        this.issueKey = issueKey;
    }

    public boolean isAllowSignUp() {
        return this.userManager.hasPasswordWritableDirectory() && JiraUtils.isPublicMode();
    }
}

