/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.issue.link.IssueLinkService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.action.issue.AbstractIssueSelectAction;
import org.ofbiz.core.entity.GenericEntityException;

public class DeleteLink
extends AbstractIssueSelectAction {
    private final IssueLinkService issueLinkService;
    private Long destId;
    private Long linkType;
    private Long sourceId;
    private IssueLink issueLink;
    private IssueLinkService.DeleteIssueLinkValidationResult validationResult;
    private boolean confirm;

    public DeleteLink(IssueLinkService issueLinkService) {
        this.issueLinkService = issueLinkService;
    }

    protected void doValidation() {
        this.validationResult = this.issueLinkService.validateDelete(this.getLoggedInUser(), this.getIssueObject(), this.getLink());
        if (!this.validationResult.isValid()) {
            this.addErrorCollection(this.validationResult.getErrorCollection());
        }
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (this.confirm) {
            this.issueLinkService.delete(this.validationResult);
            String targetID = this.hasIssueLinks(this.getLoggedInUser(), this.getIssueObject()) ? "#linkingmodule" : "";
            String redirectUrl = "/browse/" + this.getIssueObject().getKey() + targetID;
            if (this.isInlineDialogMode()) {
                return this.returnCompleteWithInlineRedirect(redirectUrl);
            }
            return this.returnComplete(redirectUrl);
        }
        return "input";
    }

    public String getDirectionName() throws GenericEntityException {
        if (this.destId != null) {
            return this.getLink().getIssueLinkType().getOutward();
        }
        if (this.sourceId != null) {
            return this.getLink().getIssueLinkType().getInward();
        }
        return null;
    }

    public String getTargetIssueKey() {
        MutableIssue issue = this.getIssueManager().getIssueObject(this.destId != null ? this.destId : this.sourceId);
        if (issue != null) {
            return issue.getKey();
        }
        return null;
    }

    private boolean hasIssueLinks(ApplicationUser user, Issue issue) {
        IssueLinkService.IssueLinkResult result = this.issueLinkService.getIssueLinks(this.getLoggedInUser(), this.getIssueObject());
        return result.isValid() && !result.getLinkCollection().getAllIssues().isEmpty();
    }

    public Long getDestId() {
        return this.destId;
    }

    public void setDestId(Long destId) {
        this.destId = destId;
    }

    public Long getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Long getLinkType() {
        return this.linkType;
    }

    public void setLinkType(Long linkType) {
        this.linkType = linkType;
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }

    public boolean isRemoteIssueLink() {
        return false;
    }

    private IssueLink getLink() {
        if (this.issueLink == null) {
            if (this.destId != null) {
                this.issueLink = this.issueLinkService.getIssueLink(this.getId(), this.destId, this.linkType);
            } else if (this.sourceId != null) {
                this.issueLink = this.issueLinkService.getIssueLink(this.sourceId, this.getId(), this.linkType);
            }
        }
        return this.issueLink;
    }
}

