/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.issue.QuickBrowseEvent;
import com.atlassian.jira.event.issue.QuickSearchEvent;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.search.util.QueryCreator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.util.JiraKeyUtils;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import webwork.action.ServletActionContext;

public class QuickSearch
extends ProjectActionSupport {
    public String searchString;
    private final QueryCreator queryCreator;
    private final EventPublisher eventPublisher;

    public QuickSearch(ProjectManager projectManager, QueryCreator queryCreator, PermissionManager permissionManager, EventPublisher eventPublisher) {
        super(projectManager, permissionManager);
        this.queryCreator = queryCreator;
        this.eventPublisher = eventPublisher;
    }

    public QuickSearch(QueryCreator queryCreator, EventPublisher eventPublisher) {
        this.queryCreator = queryCreator;
        this.eventPublisher = eventPublisher;
    }

    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (TextUtils.stringSet((String)this.getKey())) {
            this.eventPublisher.publish((Object)new QuickBrowseEvent(this.getKey()));
            return this.getRedirect("/browse/" + this.getKey());
        }
        this.eventPublisher.publish((Object)new QuickSearchEvent(this.searchString));
        this.sendInternalRedirect(this.createQuery(this.searchString));
        return "none";
    }

    protected void sendInternalRedirect(String redirectLocation) throws ServletException, IOException {
        HttpServletRequest request = ServletActionContext.getRequest();
        request.getRequestDispatcher(redirectLocation).forward((ServletRequest)request, (ServletResponse)ServletActionContext.getResponse());
    }

    protected String createQuery(String searchString) {
        return this.queryCreator.createQuery(searchString);
    }

    public String getKey() throws Exception {
        if (this.searchString == null) {
            return null;
        }
        String potentialKey = this.searchString.toUpperCase().trim();
        if (JiraKeyUtils.validIssueKey((String)potentialKey)) {
            return potentialKey;
        }
        try {
            Long.parseLong(potentialKey);
            Project searchProject = this.getSearchProject();
            if (searchProject != null) {
                return searchProject.getKey() + "-" + (potentialKey.startsWith("-") ? potentialKey.substring(1, potentialKey.length()) : potentialKey);
            }
            return potentialKey;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Project getSearchProject() throws PermissionException {
        Project project = this.getSelectedProjectObject();
        if (project != null) {
            return project;
        }
        if (this.getBrowsableProjects().size() == 1) {
            return (Project)this.getBrowsableProjects().iterator().next();
        }
        return null;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }
}

