/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue.bulkedit;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bulkedit.BulkOperationManager;
import com.atlassian.jira.bulkedit.operation.ProgressAwareBulkOperation;
import com.atlassian.jira.event.operation.SpanningOperation;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.issue.bulkedit.AbstractBulkOperationDetailsAction;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.BulkEditBeanSessionHelper;

public abstract class AbstractBulkWatchOperationAction
extends AbstractBulkOperationDetailsAction {
    private final ProgressAwareBulkOperation genericBulkWatchOperation;
    private final PermissionManager permissionManager;

    protected abstract String getOperationNameKey();

    protected abstract String getOperationName();

    protected abstract String getCannotPerformErrorI18nKey();

    protected abstract String getPerformErrorI18nKey();

    protected abstract String getWatchingDisabledErrorI18nKey();

    protected abstract String getProgressMessageI18nKey();

    public AbstractBulkWatchOperationAction(SearchService searchService, BulkOperationManager bulkOperationManager, PermissionManager permissionManager, BulkEditBeanSessionHelper bulkEditBeanSessionHelper, TaskManager taskManager, I18nHelper i18nHelper) {
        super(searchService, bulkEditBeanSessionHelper, taskManager, i18nHelper);
        this.permissionManager = permissionManager;
        this.genericBulkWatchOperation = bulkOperationManager.getProgressAwareOperation(this.getOperationNameKey());
    }

    public ProgressAwareBulkOperation getGenericBulkWatchOperation() {
        return this.genericBulkWatchOperation;
    }

    public boolean isHasAvailableActions() throws Exception {
        return this.getGenericBulkWatchOperation().canPerform(this.getBulkEditBean(), this.getLoggedInUser());
    }

    public String getOperationDetailsActionName() {
        return this.getGenericBulkWatchOperation().getOperationName() + "Details.jspa";
    }

    public void doPerformValidation() {
        try {
            if (!this.permissionManager.hasPermission(33, this.getLoggedInUser())) {
                this.addErrorMessage(this.getText("bulk.change.no.permission", String.valueOf(this.getBulkEditBean().getSelectedIssues().size())));
            }
            if (this.getGenericBulkWatchOperation() == null) {
                this.addErrorMessage(this.getText(this.getWatchingDisabledErrorI18nKey()));
                return;
            }
            if (!this.getGenericBulkWatchOperation().canPerform(this.getBulkEditBean(), this.getLoggedInUser())) {
                this.addErrorMessage(this.getText(this.getCannotPerformErrorI18nKey(), String.valueOf(this.getBulkEditBean().getSelectedIssues().size())));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error occured while testing operation.", (Throwable)e);
            this.addErrorMessage(this.getText("bulk.canperform.error"));
        }
    }

    @Override
    @SupportedMethods(value={RequestMethod.GET})
    public String doDetails() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart();
        }
        return this.getRedirect(this.getOperationName() + "DetailsValidation.jspa");
    }

    @Override
    @SupportedMethods(value={RequestMethod.GET})
    public String doDetailsValidation() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart();
        }
        BulkEditBean bulkEditBean = this.getBulkEditBean();
        bulkEditBean.clearAvailablePreviousSteps();
        bulkEditBean.addAvailablePreviousStep(1);
        bulkEditBean.addAvailablePreviousStep(2);
        bulkEditBean.addAvailablePreviousStep(3);
        bulkEditBean.setCurrentStep(4);
        return "input";
    }

    @Override
    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doPerform() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart();
        }
        this.doPerformValidation();
        if (this.invalidInput()) {
            return "error";
        }
        String taskName = this.getText(this.getProgressMessageI18nKey(), this.getRootBulkEditBean().getSelectedIssuesIncludingSubTasks().size());
        return this.submitBulkOperationTask(this.getBulkEditBean(), this.getGenericBulkWatchOperation(), taskName, this.getSpanningOperation());
    }

    protected abstract SpanningOperation getSpanningOperation();
}

