/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue.bulkedit;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bulkedit.BulkOperationManager;
import com.atlassian.jira.bulkedit.operation.ProgressAwareBulkOperation;
import com.atlassian.jira.event.operation.SpanningOperation;
import com.atlassian.jira.event.operation.SpanningOperationType;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.project.archiving.ArchivingLicenseCheck;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.issue.bulkedit.AbstractBulkOperationDetailsAction;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.BulkEditBeanSessionHelper;

public class BulkArchive
extends AbstractBulkOperationDetailsAction {
    private final ProgressAwareBulkOperation bulkArchiveOperation;
    private final PermissionManager permissionManager;
    private final ArchivingLicenseCheck archivingLicenseCheck;
    private final HelpUrls helpUrls;

    public BulkArchive(SearchService searchService, BulkOperationManager bulkOperationManager, PermissionManager permissionManager, BulkEditBeanSessionHelper bulkEditBeanSessionHelper, TaskManager taskManager, I18nHelper i18nHelper, ArchivingLicenseCheck archivingLicenseCheck, HelpUrls helpUrls) {
        super(searchService, bulkEditBeanSessionHelper, taskManager, i18nHelper);
        this.permissionManager = permissionManager;
        this.bulkArchiveOperation = bulkOperationManager.getProgressAwareOperation("bulk.archive.operation.name");
        this.archivingLicenseCheck = archivingLicenseCheck;
        this.helpUrls = helpUrls;
    }

    public boolean isHasAvailableActions() throws Exception {
        return this.getBulkArchiveOperation().canPerform(this.getBulkEditBean(), this.getLoggedInUser());
    }

    public void doPerformValidation() {
        try {
            if (!this.permissionManager.hasPermission(33, this.getLoggedInUser())) {
                this.addErrorMessage(this.getText("bulk.change.no.permission", String.valueOf(this.getBulkEditBean().getSelectedIssues().size())));
            }
            if (!this.archivingLicenseCheck.isLicensedForIssueArchiving()) {
                this.addErrorMessage(this.getText("bulk.archive.cannotperform.notlicenced.error", String.valueOf(this.getBulkEditBean().getSelectedIssues().size())));
            }
            if (!this.getBulkArchiveOperation().canPerform(this.getBulkEditBean(), this.getLoggedInUser())) {
                this.addErrorMessage(this.getText("bulk.archive.cannotperform.error", String.valueOf(this.getBulkEditBean().getSelectedIssues().size())));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error occured while testing operation.", (Throwable)e);
            this.addErrorMessage(this.getText("bulk.canperform.error"));
        }
    }

    @Override
    @SupportedMethods(value={RequestMethod.GET})
    public String doDetails() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart();
        }
        if (this.isCanDisableMailNotifications() && this.getBulkEditBean().isHasMailServer()) {
            BulkEditBean bulkEditBean = this.getBulkEditBean();
            bulkEditBean.clearAvailablePreviousSteps();
            bulkEditBean.addAvailablePreviousStep(1);
            bulkEditBean.addAvailablePreviousStep(2);
            if (this.isCanDisableMailNotifications()) {
                bulkEditBean.setSendBulkNotification(false);
            } else {
                bulkEditBean.setSendBulkNotification(true);
            }
            bulkEditBean.setCurrentStep(3);
            return "input";
        }
        return this.getRedirect("BulkArchiveDetailsValidation.jspa");
    }

    @Override
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    public String doDetailsValidation() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart();
        }
        BulkEditBean bulkEditBean = this.getBulkEditBean();
        bulkEditBean.clearAvailablePreviousSteps();
        bulkEditBean.addAvailablePreviousStep(1);
        bulkEditBean.addAvailablePreviousStep(2);
        bulkEditBean.addAvailablePreviousStep(3);
        bulkEditBean.setCurrentStep(4);
        return "input";
    }

    @Override
    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doPerform() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart();
        }
        this.doPerformValidation();
        if (this.invalidInput()) {
            return "error";
        }
        String taskName = this.getText("bulk.operation.progress.taskname.archive", this.getRootBulkEditBean().getSelectedIssuesIncludingSubTasks().size());
        return this.submitBulkOperationTask(this.getBulkEditBean(), this.getBulkArchiveOperation(), taskName, SpanningOperation.builder().type(SpanningOperationType.BULK_ARCHIVE).generatedId().build());
    }

    public ProgressAwareBulkOperation getBulkArchiveOperation() {
        return this.bulkArchiveOperation;
    }

    public String getHelpUrl() {
        return this.helpUrls.getUrl("issue.archive").getUrl();
    }
}

