/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.projectcategory;

import com.atlassian.jira.entity.ProjectCategoryFactory;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;

@WebSudoRequired
public class EditProjectCategory
extends ProjectActionSupport {
    private Long id = null;
    private String name = null;
    private String description = null;

    protected void doValidation() {
        if (!TextUtils.stringSet((String)this.getName())) {
            this.addError("name", this.getText("admin.errors.please.specify.a.name"));
        }
        if (null == this.getId() || null == this.projectManager.getProjectCategoryObject(this.getId())) {
            this.addErrorMessage(this.getText("admin.errors.project.category.does.not.exist"));
        } else {
            for (ProjectCategory projectCategory : this.projectManager.getAllProjectCategories()) {
                if (this.getId().equals(projectCategory.getId()) || !TextUtils.noNull((String)this.getName()).equalsIgnoreCase(projectCategory.getName())) continue;
                this.addError("name", this.getText("admin.errors.project.category.already.exists", "'" + this.getName() + "'"));
                break;
            }
        }
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        if (null == this.getId() || null == this.projectManager.getProjectCategoryObject(this.getId())) {
            this.addErrorMessage(this.getText("admin.errors.project.category.does.not.exist"));
        } else {
            ProjectCategory projectCategory = this.projectManager.getProjectCategoryObject(this.getId());
            this.setName(projectCategory.getName());
            this.setDescription(projectCategory.getDescription());
        }
        return "input";
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        ProjectCategoryFactory.Builder builder = new ProjectCategoryFactory.Builder();
        builder.id(this.getId());
        builder.name(this.getName());
        builder.description(this.description);
        this.projectManager.updateProjectCategory(builder.build());
        return this.getRedirect("ViewProjectCategories!default.jspa");
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

