/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.JiraProductInformation;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.web.HttpServletVariables;
import com.atlassian.license.SIDManager;
import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class MyAtlassianComRedirect {
    private final JiraProductInformation jiraProductInformation;
    private final BuildUtilsInfo buildUtilsInfo;
    private final SIDManager sidManager;
    private final ApplicationProperties applicationProperties;
    private final HttpServletVariables servletVariables;

    public MyAtlassianComRedirect(JiraProductInformation jiraProductInformation, BuildUtilsInfo buildUtilsInfo, SIDManager sidManager, ApplicationProperties applicationProperties, HttpServletVariables servletVariables) {
        this.jiraProductInformation = jiraProductInformation;
        this.buildUtilsInfo = buildUtilsInfo;
        this.sidManager = sidManager;
        this.applicationProperties = applicationProperties;
        this.servletVariables = servletVariables;
    }

    public MyAtlassianComRedirectBuilder newRedirectWithCallbackTo(String postCallbackUrl) {
        return new MyAtlassianComRedirectBuilder(postCallbackUrl);
    }

    private String getServerId() {
        return Optional.ofNullable(this.applicationProperties.getString("jira.sid.key")).orElseGet(this::generateAndStoreSid);
    }

    private String generateAndStoreSid() {
        String serverId = this.sidManager.generateSID();
        this.applicationProperties.setString("jira.sid.key", serverId);
        return serverId;
    }

    public final class MyAtlassianComRedirectBuilder {
        private final String postCallabckUrl;

        private MyAtlassianComRedirectBuilder(String postCallbackUrl) {
            if (StringUtils.isBlank((CharSequence)postCallbackUrl)) {
                throw new IllegalArgumentException();
            }
            this.postCallabckUrl = postCallbackUrl;
        }

        public String buildWithPostReturnParameter(String dataAttribute) {
            if (StringUtils.isBlank((CharSequence)dataAttribute)) {
                throw new IllegalArgumentException();
            }
            String macUrl = "https://www.atlassian.com/ex/GenerateLicense.jspa";
            ImmutableMap params = ImmutableMap.builder().put((Object)"utm_nooverride", (Object)"1").put((Object)"ref", (Object)"prod").put((Object)"product", (Object)MyAtlassianComRedirect.this.jiraProductInformation.getLicenseProductKey()).put((Object)"version", (Object)MyAtlassianComRedirect.this.buildUtilsInfo.getVersion()).put((Object)"build", (Object)Integer.toString(MyAtlassianComRedirect.this.buildUtilsInfo.getApplicationBuildNumber())).put((Object)"sid", (Object)MyAtlassianComRedirect.this.getServerId()).put((Object)"licensefieldname", (Object)dataAttribute).put((Object)"callback", (Object)this.buildUrl()).build();
            return "https://www.atlassian.com/ex/GenerateLicense.jspa?" + this.encodeParams((ImmutableMap<String, String>)params);
        }

        private String encodeParams(ImmutableMap<String, String> params) {
            return params.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"));
        }

        private String buildUrl() {
            String baseUrl = JiraUrl.constructBaseUrl((HttpServletRequest)MyAtlassianComRedirect.this.servletVariables.getHttpRequest());
            String sanitizedReturnUrl = this.postCallabckUrl.startsWith("/") ? this.postCallabckUrl.substring(1) : this.postCallabckUrl;
            return baseUrl.endsWith("/") ? baseUrl + sanitizedReturnUrl : baseUrl + "/" + sanitizedReturnUrl;
        }
    }
}

