/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.plugin.webresource.JiraWebResourceManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraProductInformation;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.setup.AbstractSetupAction;
import com.atlassian.jira.web.action.setup.MyAtlassianComRedirect;
import com.atlassian.jira.web.action.setup.SetupSharedVariables;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetupMode
extends AbstractSetupAction {
    private static final String SETUP_CLASSIC = "classic";
    private static final String SETUP_INSTANT = "instant";
    private String setupOption = "classic";
    private final DatabaseConfigurationManager databaseConfigurationManager;
    private final JiraWebResourceManager webResourceManager;
    private final BuildUtilsInfo buildUtilsInfo;
    private final SetupSharedVariables sharedVariables;
    private final MyAtlassianComRedirect macHelper;
    private static final Logger log = LoggerFactory.getLogger(SetupMode.class);
    private String localeForTexts;
    private String jiraLanguage;

    public SetupMode(FileFactory fileFactory, JiraProperties jiraProperties, DatabaseConfigurationManager databaseConfigurationManager, JiraWebResourceManager webResourceManager, BuildUtilsInfo buildUtilsInfo, SetupSharedVariables setupSharedVariables, JiraProductInformation jiraProductInformation, MyAtlassianComRedirect macHelper) {
        super(fileFactory, jiraProperties, jiraProductInformation);
        this.databaseConfigurationManager = databaseConfigurationManager;
        this.webResourceManager = webResourceManager;
        this.buildUtilsInfo = buildUtilsInfo;
        this.sharedVariables = setupSharedVariables;
        this.macHelper = macHelper;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        if (this.databaseConfigurationManager.isDatabaseSetup()) {
            return this.getRedirect("SetupDatabase!default.jspa");
        }
        this.webResourceManager.putMetadata("version-number", this.buildUtilsInfo.getVersion());
        return "input";
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doExecute() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        this.sharedVariables.setIsInstantSetup(SETUP_INSTANT.equals(this.setupOption));
        if (this.sharedVariables.getIsInstantSetup()) {
            return this.getRedirect(this.macHelper.newRedirectWithCallbackTo("/secure/SetupAccount!default.jspa").buildWithPostReturnParameter("productLicense"), true);
        }
        return this.getRedirect("SetupDatabase!default.jspa");
    }

    public String getSetupOption() {
        return this.setupOption;
    }

    public void setSetupOption(String setupOption) {
        this.setupOption = setupOption;
    }

    @ActionViewData
    public String getSelectedMode() {
        if (!this.sharedVariables.isSetupModeDecided()) {
            return null;
        }
        return this.sharedVariables.getIsInstantSetup() ? SETUP_INSTANT : SETUP_CLASSIC;
    }

    private Map<String, String> getInstalledLocales() {
        Set installedLocales = ((LocaleManager)ComponentAccessor.getComponentOfType(LocaleManager.class)).getInstalledLocales();
        LinkedHashMap<String, String> localeMap = new LinkedHashMap<String, String>();
        for (Locale installedLocale : installedLocales) {
            localeMap.put(installedLocale.toString(), installedLocale.getDisplayName(installedLocale));
        }
        return localeMap;
    }

    public String getDefaultServerLanguage() {
        String defaultLocale = ComponentAccessor.getApplicationProperties().getDefaultLocale().toString();
        if (this.getInstalledLocales().keySet().contains(defaultLocale)) {
            return defaultLocale;
        }
        return "en_UK";
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doGetInstalledLocales() throws JSONException, IOException {
        HttpServletResponse response = this.getHttpResponse();
        LocaleManager localeManager = (LocaleManager)ComponentAccessor.getComponentOfType(LocaleManager.class);
        Set installedLocales = localeManager.getInstalledLocales();
        JSONObject jsonObject = new JSONObject();
        JSONObject locales = new JSONObject();
        for (Locale installedLocale : installedLocales) {
            locales.put(installedLocale.toString(), (Object)installedLocale.getDisplayName(installedLocale));
        }
        jsonObject.put("currentLocale", (Object)this.getDefaultServerLanguage());
        jsonObject.put("locales", (Object)locales);
        response.setContentType("application/json");
        response.getWriter().write(jsonObject.toString());
        response.getWriter().flush();
        return "none";
    }

    @ActionViewData(key="languageDialogDefaultTexts")
    public String getLanguageTextsJson() throws JSONException {
        return this.getLanguageTextsJsonForLocale(this.getLocale());
    }

    private String getLanguageTextsJsonForLocale(Locale locale) throws JSONException {
        I18nHelper i18nHelper = ComponentAccessor.getI18nHelperFactory().getInstance(locale);
        JSONObject json = new JSONObject();
        json.put("button", (Object)i18nHelper.getText("common.words.save"));
        json.put("cancel", (Object)i18nHelper.getText("common.forms.cancel"));
        json.put("connectionWarningContent", (Object)i18nHelper.getText("setup.language.dialog.connection.warning.content"));
        json.put("connectionWarningTitle", (Object)i18nHelper.getText("setup.language.dialog.connection.warning.title"));
        json.put("langLabel", (Object)i18nHelper.getText("setup.choose.language"));
        json.put("langDesc", (Object)i18nHelper.getText("setupdb.server.language.description"));
        json.put("header", (Object)i18nHelper.getText("setup.language.dialog.header"));
        return json.toString();
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doGetLanguageTexts() throws JSONException, IOException {
        HttpServletResponse response = this.getHttpResponse();
        LocaleManager localeManager = (LocaleManager)ComponentAccessor.getComponentOfType(LocaleManager.class);
        Locale locale = localeManager.getLocale(this.localeForTexts);
        response.setContentType("application/json");
        response.getWriter().write(this.getLanguageTextsJsonForLocale(locale));
        response.getWriter().flush();
        return "none";
    }

    @SupportedMethods(value={RequestMethod.POST})
    public String doChangeLanguage() throws IOException {
        HttpServletResponse response = this.getHttpResponse();
        LocaleManager localeManager = (LocaleManager)ComponentAccessor.getComponentOfType(LocaleManager.class);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        localeManager.validateUserLocale(this.getLoggedInUser(), this.getJiraLanguage(), (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            log.warn("Invalid locale submitted ({}), JIRA locale will not be changed", (Object)this.getJiraLanguage());
            response.setStatus(400);
        } else {
            this.setJiraLocale(this.getJiraLanguage());
            this.setIndexingLanguageForDefaultServerLocale();
        }
        response.setContentType("application/json");
        response.getWriter().write("{}");
        response.getWriter().flush();
        return "none";
    }

    public void setLocaleForTexts(String localeForTexts) {
        this.localeForTexts = localeForTexts;
    }

    public String getJiraLanguage() {
        return this.jiraLanguage;
    }

    public void setJiraLanguage(String jiraLanguage) {
        this.jiraLanguage = jiraLanguage;
    }
}

