/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.web.HttpServletVariables;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class SetupSharedVariables {
    private static final String SETUP_INSTANT_JIRA_LICENSE_KEY = "setup-instant-jira-license-key";
    private static final String SETUP_INSTANT_EMAIL = "setup-instant-email";
    private static final String SETUP_INSTANT_USERNAME = "setup-instant-username";
    private static final String SETUP_INSTANT_PASSWORD = "setup-instant-password";
    private static final String SETUP_JIRA_LOCAL = "setup-jira-local";
    private final ApplicationProperties applicationProperties;
    private final HttpServletVariables servletVariables;

    public SetupSharedVariables(HttpServletVariables servletVariables, ApplicationProperties applicationProperties) {
        this.servletVariables = servletVariables;
        this.applicationProperties = applicationProperties;
    }

    public String getJiraLicenseKey() {
        return (String)this.servletVariables.getHttpSession().getAttribute(SETUP_INSTANT_JIRA_LICENSE_KEY);
    }

    public void setJiraLicenseKey(String licenseKey) {
        this.servletVariables.getHttpSession().setAttribute(SETUP_INSTANT_JIRA_LICENSE_KEY, (Object)licenseKey);
    }

    public void setUserCredentials(String email, String username, String password) {
        this.servletVariables.getHttpSession().setAttribute(SETUP_INSTANT_EMAIL, (Object)email);
        this.servletVariables.getHttpSession().setAttribute(SETUP_INSTANT_USERNAME, (Object)username);
        this.servletVariables.getHttpSession().setAttribute(SETUP_INSTANT_PASSWORD, (Object)password);
    }

    public Map<String, String> getUserCredentials() {
        return ImmutableMap.of((Object)"email", (Object)((String)this.servletVariables.getHttpSession().getAttribute(SETUP_INSTANT_EMAIL)), (Object)"username", (Object)((String)this.servletVariables.getHttpSession().getAttribute(SETUP_INSTANT_USERNAME)), (Object)"password", (Object)((String)this.servletVariables.getHttpSession().getAttribute(SETUP_INSTANT_PASSWORD)));
    }

    public void setIsInstantSetup(boolean isInstant) {
        this.applicationProperties.setOption("jira.setup.is.instant", isInstant);
        this.applicationProperties.setOption("jira.setup.mode.decided", true);
    }

    public boolean getIsInstantSetup() {
        return this.applicationProperties.getOption("jira.setup.is.instant");
    }

    public boolean isSetupModeDecided() {
        return this.applicationProperties.getOption("jira.setup.mode.decided");
    }

    public void setLocale(String locale) {
        this.servletVariables.getHttpSession().setAttribute(SETUP_JIRA_LOCAL, (Object)locale);
    }

    public String getLocale() {
        return (String)this.servletVariables.getHttpSession().getAttribute(SETUP_JIRA_LOCAL);
    }

    public String getBaseUrl() {
        return JiraUrl.constructBaseUrl((HttpServletRequest)this.servletVariables.getHttpRequest());
    }
}

