/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.NonZipExpandableExtensions;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrTokenizer;

public class ApplicationPropertiesBackedNonZipExpandableExtensions
implements NonZipExpandableExtensions {
    static final String DEFAULT_JIRA_ATTACHMENT_DO_NOT_EXPAND_AS_ZIP_EXTENSIONS_LIST = "docx, docm, dotx, dotm, xlsx, xlsm, xltx, xltm, xlsb, xlam, pptx, pptm, potx, potm, ppam, ppsx, ppsm, sldx, sldm, thmx,odt, odp, ods, odg, odb, odf, ott, otp, ots, otg, odm, sxw, stw, sxc, stc, sxi, sti, sxd, std, sxg";
    private final ApplicationProperties applicationProperties;

    public ApplicationProperties getApplicationProperties() {
        return this.applicationProperties;
    }

    public ApplicationPropertiesBackedNonZipExpandableExtensions(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    @Override
    public String getNonExpandableExtensionsList() {
        if (this.getApplicationProperties().getDefaultBackedString("jira.attachment.do.not.expand.as.zip.extensions.list") == null) {
            return DEFAULT_JIRA_ATTACHMENT_DO_NOT_EXPAND_AS_ZIP_EXTENSIONS_LIST;
        }
        return this.getApplicationProperties().getDefaultBackedString("jira.attachment.do.not.expand.as.zip.extensions.list");
    }

    @Override
    public boolean contains(String extension) {
        return this.contains(extension, this.getNonExpandableExtensionsList());
    }

    boolean contains(String extension, String nonExpandableExtensionsList) {
        Assertions.notNull((String)"extension", (Object)extension);
        if (!StringUtils.isBlank((CharSequence)extension)) {
            StrTokenizer tokenizer = StrTokenizer.getCSVInstance((String)nonExpandableExtensionsList);
            while (tokenizer.hasNext()) {
                String nonExpandableExtension = tokenizer.nextToken();
                if (!nonExpandableExtension.equalsIgnoreCase(extension)) continue;
                return true;
            }
        }
        return false;
    }
}

