/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.jira.bulkedit.operation.BulkMoveOperation;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.fields.option.IssueConstantOption;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.admin.issuetypes.ExecutableAction;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.BulkEditBeanImpl;
import com.atlassian.jira.web.bean.MultiBulkMoveBean;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiBulkMoveBeanImpl
implements MultiBulkMoveBean {
    private static final Logger log = LoggerFactory.getLogger(MultiBulkMoveBeanImpl.class);
    private String operationName;
    private ListOrderedMap regularIssues;
    private List<Issue> subTaskIssues;
    private ListOrderedMap issuesInContext;
    private ListOrderedMap bulkEditBeans;
    private Collection optionIds;
    private List<IssueConstantOption> regularOptions;
    private List<IssueConstantOption> subTaskOptions;
    private ExecutableAction executableAction;
    private String finalLocation;
    private int currentBulkEditBeanIndex = 0;
    private int subTasksDiscarded = 0;
    private final ConstantsManager constantsManager;
    private final JiraAuthenticationContext authenticationContext;
    private final IssueManager issueManager;
    private final IssueLinkManager issueLinkManager;

    public MultiBulkMoveBeanImpl(String operationName, IssueManager issueManager, IssueLinkManager issueLinkManager) {
        this.operationName = operationName;
        this.issueManager = issueManager;
        this.constantsManager = ComponentAccessor.getConstantsManager();
        this.authenticationContext = ComponentAccessor.getJiraAuthenticationContext();
        this.issueLinkManager = issueLinkManager;
    }

    public void initOptionIds(Collection optionIds) {
        this.optionIds = optionIds;
        this.regularOptions = Lists.newArrayListWithCapacity((int)optionIds.size());
        this.subTaskOptions = Lists.newArrayListWithCapacity((int)optionIds.size());
        for (Object optionId1 : optionIds) {
            String optionId = (String)optionId1;
            IssueType issueType = this.constantsManager.getIssueType(optionId);
            if (!issueType.isSubTask()) {
                this.regularOptions.add(new IssueConstantOption((IssueConstant)issueType));
                continue;
            }
            this.subTaskOptions.add(new IssueConstantOption((IssueConstant)issueType));
        }
    }

    public void initFromIssues(List issues, BulkEditBean parentBulkEditBean) {
        MutableIssue issue2;
        this.issuesInContext = (ListOrderedMap)ListOrderedMap.decorate((Map)new MultiHashMap());
        this.regularIssues = new ListOrderedMap();
        this.subTaskIssues = Lists.newArrayListWithCapacity((int)issues.size());
        List issueIds = issues.stream().map(issue -> ((MutableIssue)issue).getId()).collect(Collectors.toList());
        Set subtasks = this.issueLinkManager.getInwardLinksInBatch(issueIds).entrySet().stream().filter(entry -> ((List)entry.getValue()).stream().anyMatch(link -> link.getIssueLinkType().isSubTaskLinkType())).map(entry -> (Long)entry.getKey()).collect(Collectors.toSet());
        for (Object issue22 : issues) {
            issue2 = (MutableIssue)issue22;
            if (!subtasks.contains(issue2.getId())) {
                this.regularIssues.put((Object)issue2.getId(), (Object)issue2);
                continue;
            }
            this.subTaskIssues.add((Issue)issue2);
        }
        for (Object issue1 : issues) {
            boolean step2SubtaskProcessing;
            issue2 = (MutableIssue)issue1;
            if ("BulkMigrate".equals(this.operationName) && subtasks.contains(issue2.getId()) && this.regularIssues.containsKey((Object)issue2.getParentId())) {
                log.info("Sub issue: " + issue2.getKey() + " : discarded since parent was also present in the bulk move");
                ++this.subTasksDiscarded;
                continue;
            }
            boolean bl = step2SubtaskProcessing = parentBulkEditBean != null;
            if (!step2SubtaskProcessing && "BulkMigrate".equals(this.operationName)) {
                this.issuesInContext.put((Object)new IssueContextWithParentProjectImpl(issue2.getProjectObject(), issue2.getIssueType(), issue2.getParentObject()), (Object)issue2);
                continue;
            }
            this.issuesInContext.put((Object)new IssueContextImpl(issue2.getProjectObject(), issue2.getIssueType()), (Object)issue2);
        }
        this.bulkEditBeans = new ListOrderedMap();
        ArrayList keys = new ArrayList(this.issuesInContext.keySet());
        Collections.sort(keys);
        for (Object key : keys) {
            IssueContextWithParentProjectImpl contextWithParent;
            IssueContext context = (IssueContext)key;
            Collection issuesForContext = (Collection)this.issuesInContext.get((Object)context);
            BulkEditBeanImpl bulkEditBean = new BulkEditBeanImpl(this.issueManager);
            bulkEditBean.initSelectedIssues(issuesForContext);
            bulkEditBean.setOperationName(this.operationName);
            bulkEditBean.setTargetProject(context.getProjectObject());
            bulkEditBean.setTargetIssueTypeId(context.getIssueTypeObject() != null ? context.getIssueTypeId() : null);
            bulkEditBean.setParentBulkEditBean(parentBulkEditBean);
            if (bulkEditBean.isSubTaskOnly() && key instanceof IssueContextWithParentProjectImpl && (contextWithParent = (IssueContextWithParentProjectImpl)((Object)key)).getParentIssue() != null) {
                bulkEditBean.setParentIssueKey(contextWithParent.getParentIssue().getKey());
            }
            this.bulkEditBeans.put((Object)context, (Object)bulkEditBean);
        }
    }

    public void remapBulkEditBeansByTargetContext() {
        ListOrderedMap bulkEditBeans = this.getBulkEditBeans();
        ListOrderedMap targetKeyedBulkEditBeans = new ListOrderedMap();
        Set entries = bulkEditBeans.entrySet();
        for (Map.Entry entry1 : entries) {
            Map.Entry entry = entry1;
            BulkEditBean bulkEditBean = (BulkEditBean)entry.getValue();
            IssueContextWithParentProjectImpl targetIssueContext = new IssueContextWithParentProjectImpl(bulkEditBean.getTargetProject(), bulkEditBean.getTargetIssueTypeObject(), bulkEditBean.getParentIssueObject());
            if (targetKeyedBulkEditBeans.containsKey((Object)targetIssueContext)) {
                BulkEditBean finalBulkEditBean = (BulkEditBean)targetKeyedBulkEditBeans.get((Object)targetIssueContext);
                finalBulkEditBean.addIssues((Collection)bulkEditBean.getSelectedIssues());
                continue;
            }
            targetKeyedBulkEditBeans.put((Object)targetIssueContext, (Object)bulkEditBean);
        }
        this.setBulkEditBeans(targetKeyedBulkEditBeans);
    }

    public void validate(ErrorCollection errors, BulkMoveOperation bulkMoveOperation, ApplicationUser applicationUser) {
        if (!this.regularIssues.isEmpty() && this.regularOptions.isEmpty()) {
            errors.addErrorMessage(this.authenticationContext.getI18nHelper().getText("admin.errors.bean.issues.affected", "" + this.regularIssues.size()));
        }
        if (!this.subTaskIssues.isEmpty() && this.subTaskOptions.isEmpty()) {
            errors.addErrorMessage(this.authenticationContext.getI18nHelper().getText("admin.errors.bean.subtasks.affected", "" + this.subTaskIssues.size()));
        }
        Set entries = this.bulkEditBeans.entrySet();
        for (Object entry1 : entries) {
            Map.Entry entry = (Map.Entry)entry1;
            IssueContext issueContext = (IssueContext)entry.getKey();
            BulkEditBean bulkEditBean = (BulkEditBean)entry.getValue();
            if (bulkMoveOperation.canPerform(bulkEditBean, applicationUser)) continue;
            errors.addErrorMessage(this.authenticationContext.getI18nHelper().getText("admin.errors.bean.no.permission", "" + issueContext.getProjectObject().getName(), "" + issueContext.getIssueTypeObject().getName()));
        }
    }

    public ListOrderedMap getIssuesInContext() {
        return this.issuesInContext;
    }

    public ListOrderedMap getBulkEditBeans() {
        return this.bulkEditBeans;
    }

    private void setBulkEditBeans(ListOrderedMap bulkEditBeans) {
        this.bulkEditBeans = bulkEditBeans;
    }

    public ExecutableAction getExecutableAction() {
        return this.executableAction;
    }

    public void setExecutableAction(ExecutableAction executableAction) {
        this.executableAction = executableAction;
    }

    public String getFinalLocation() {
        return this.finalLocation;
    }

    public void setFinalLocation(String finalLocation) {
        this.finalLocation = finalLocation;
    }

    public Collection getSelectedOptions() {
        return this.optionIds;
    }

    public List getRegularOptions() {
        return this.regularOptions;
    }

    public List getSubTaskOptions() {
        return this.subTaskOptions;
    }

    public int getSubTasksDiscarded() {
        return this.subTasksDiscarded;
    }

    public int getNumberOfStatusChangeRequired(BulkMoveOperation bulkMoveOperation) {
        int i = 0;
        for (Object o : this.bulkEditBeans.values()) {
            BulkEditBean bulkEditBean = (BulkEditBean)o;
            if (bulkEditBean.getTargetPid() == null || bulkMoveOperation.isStatusValid(bulkEditBean)) continue;
            ++i;
        }
        return i;
    }

    public BulkEditBean getCurrentBulkEditBean() {
        if (!this.getBulkEditBeans().isEmpty()) {
            return (BulkEditBean)this.getBulkEditBeans().getValue(this.currentBulkEditBeanIndex);
        }
        return null;
    }

    public void progressToNextBulkEditBean() {
        if (!this.isLastBulkEditBean()) {
            ++this.currentBulkEditBeanIndex;
        } else {
            throw new IllegalArgumentException("Unable to progress to bulk edit bean with index greater than " + this.currentBulkEditBeanIndex + ". " + this.getBulkEditBeans().size() + " bulk edit beans available");
        }
    }

    public void progressToPreviousBulkEditBean() {
        if (this.currentBulkEditBeanIndex > 0) {
            --this.currentBulkEditBeanIndex;
        } else {
            throw new IllegalArgumentException("Unable to progress to bulk edit bean with index less than 0");
        }
    }

    public boolean isLastBulkEditBean() {
        return this.currentBulkEditBeanIndex == this.getBulkEditBeans().size() - 1;
    }

    public IssueContext getCurrentIssueContext() {
        if (!this.getBulkEditBeans().isEmpty()) {
            return (IssueContext)this.getBulkEditBeans().get(this.currentBulkEditBeanIndex);
        }
        return null;
    }

    public int getCurrentBulkEditBeanIndex() {
        return this.currentBulkEditBeanIndex;
    }

    public void setTargetProject(GenericValue targetProjectGV) {
        for (Object o : this.getBulkEditBeans().values()) {
            BulkEditBean bulkEditBean = (BulkEditBean)o;
            bulkEditBean.setTargetProject(targetProjectGV);
        }
    }

    public void setTargetProject(Project targetProject) {
        for (Object o : this.getBulkEditBeans().values()) {
            BulkEditBean bulkEditBean = (BulkEditBean)o;
            bulkEditBean.setTargetProject(targetProject);
        }
    }

    public void setParentIssueKey(String key) {
        for (Object o : this.getBulkEditBeans().values()) {
            BulkEditBean bulkEditBean = (BulkEditBean)o;
            bulkEditBean.setParentIssueKey(key);
        }
    }

    private static class IssueContextWithParentProjectImpl
    extends IssueContextImpl {
        private String parentIssueId = null;
        private Issue parentIssue = null;

        public IssueContextWithParentProjectImpl(@Nullable Project project, @Nullable IssueType issueType, @Nullable Issue parentIssue) {
            super(project, issueType);
            this.parentIssue = parentIssue;
            this.parentIssueId = Optional.ofNullable(parentIssue).map(Issue::getId).map(Object::toString).orElse(null);
        }

        public String getParentIssueId() {
            return this.parentIssueId;
        }

        public void setParentIssueId(String parentIssueId) {
            this.parentIssueId = parentIssueId;
        }

        public Issue getParentIssue() {
            return this.parentIssue;
        }

        public void setParentIssue(Issue parentIssue) {
            this.parentIssue = parentIssue;
            this.parentIssueId = parentIssue != null ? "" + parentIssue.getId() : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            IssueContextWithParentProjectImpl that = (IssueContextWithParentProjectImpl)((Object)o);
            return !(this.parentIssueId == null ? that.parentIssueId != null : !this.parentIssueId.equals(that.parentIssueId));
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.parentIssueId != null ? this.parentIssueId.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "IssueContextWithParentProjectImpl[projectId=" + this.getProjectId() + ",issueTypeId=" + this.getIssueTypeId() + ",parentIssueId=" + this.parentIssueId + ']';
        }
    }
}

