/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean.i18n;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.i18n.terminology.TerminologyMapTransformer;
import com.atlassian.jira.web.bean.i18n.CompressedKeyStore;
import com.atlassian.jira.web.bean.i18n.StringBackedStore;
import com.atlassian.jira.web.bean.i18n.TranslationStore;
import com.atlassian.jira.web.bean.i18n.TranslationStoreFactory;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DefaultTranslationStoreFactory
implements TranslationStoreFactory {
    @VisibleForTesting
    static String COMPRESS_I18N_PROPERTY = "jira.i18n.compress";
    private final JiraProperties properties;
    private final TerminologyMapTransformer terminologyMapTransformer;

    public DefaultTranslationStoreFactory(JiraProperties properties) {
        this(properties, null);
    }

    public DefaultTranslationStoreFactory(JiraProperties properties, TerminologyMapTransformer terminologyMapTransformer) {
        this.properties = properties;
        this.terminologyMapTransformer = terminologyMapTransformer;
    }

    @Override
    public TranslationStore createTranslationStore(Map<String, String> originalBundles) {
        boolean compress = false;
        String compressOverride = this.properties.getProperty(COMPRESS_I18N_PROPERTY);
        if (StringUtils.isNotBlank((CharSequence)compressOverride)) {
            compress = Boolean.valueOf(compressOverride);
        }
        Map<String, String> resultBundles = this.terminologyMapTransformer == null ? originalBundles : this.terminologyMapTransformer.transformAll(originalBundles);
        return compress ? new CompressedKeyStore(resultBundles) : new StringBackedStore(resultBundles);
    }
}

