/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.dispatcher;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.jira.web.dispatcher.ActionViewDataSupport;
import com.atlassian.jira.web.dispatcher.SoyTemplateAddress;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.config.util.ActionInfo;
import webwork.dispatcher.ActionResult;

class JiraSoyViewDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(JiraSoyViewDispatcher.class);
    private static final Supplier<ServletException> UNAVAILABLE = () -> new ServletException("Soy renderer unavailable");
    private final ActionViewDataSupport actionViewDataSupport = new ActionViewDataSupport();

    JiraSoyViewDispatcher() {
    }

    public void dispatch(HttpServletResponse httpServletResponse, ActionResult ar, ActionInfo.ViewInfo viewInfo) throws ServletException, IOException {
        try {
            HashMap parameters = Maps.newHashMap(this.actionViewDataSupport.getData(ar, viewInfo));
            JiraSoyViewDispatcher.render(httpServletResponse, viewInfo, parameters);
        }
        catch (SoyException e) {
            LOG.debug("Unable to render soy template for view '{}'", (Throwable)e);
            throw new ServletException(Throwables.getRootCause((Throwable)e));
        }
    }

    private static void render(HttpServletResponse response, ActionInfo.ViewInfo viewInfo, Map<String, Object> parameters) throws ServletException, IOException {
        SoyTemplateAddress soy = SoyTemplateAddress.address(viewInfo);
        JiraSoyViewDispatcher.soyRenderer().render((Appendable)response.getWriter(), soy.getCompleteKey(), soy.getTemplateName(), parameters);
    }

    @Nonnull
    private static SoyTemplateRenderer soyRenderer() throws ServletException {
        return ComponentAccessor.getComponentSafely(SoyTemplateRendererProvider.class).map(SoyTemplateRendererProvider::getRenderer).orElseThrow(UNAVAILABLE);
    }
}

