/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters;

import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.util.mime.MimeManager;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractStaticResourceAwareFilter
extends AbstractHttpFilter {
    private boolean cached = false;
    private Set<String> virtualDirectories = Collections.emptySet();
    private Set<String> excludedMimes = defaultContentTypes;
    private static final Set<String> defaultContentTypes = ImmutableSet.of((Object)"image/", (Object)"application/x-font", (Object)"font/", (Object)"text/plain", (Object)"text/css", (Object)"text/cvs", (Object[])new String[]{"text/javascript"});

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.shouldRunInternalFilter(request)) {
            this.doFilterInternal(request, response, filterChain);
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected abstract void doFilterInternal(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws IOException, ServletException;

    private boolean shouldRunInternalFilter(HttpServletRequest request) {
        try {
            String uri = request.getRequestURI();
            this.cacheProperties();
            return StringUtils.isBlank((CharSequence)uri) || !this.isStaticResource(uri) && !this.isVirtualDirectory(uri);
        }
        catch (RuntimeException e) {
            return true;
        }
    }

    private boolean isStaticResource(String requestURI) {
        return ComponentAccessor.getComponentSafely(MimeManager.class).map(mimeManager -> mimeManager.getSuggestedMimeType(requestURI)).map(resourceMimeType -> this.excludedMimes.stream().anyMatch(type -> StringUtils.startsWithIgnoreCase((CharSequence)resourceMimeType, (CharSequence)type))).orElse(false);
    }

    private boolean isVirtualDirectory(String requestURI) {
        return this.virtualDirectories.stream().anyMatch(path -> StringUtils.startsWithIgnoreCase((CharSequence)requestURI, (CharSequence)path));
    }

    private void cacheProperties() {
        if (!this.cached) {
            ComponentAccessor.getComponentSafely(ApplicationProperties.class).ifPresent(this::readValuesFromProperties);
        }
    }

    private void readValuesFromProperties(ApplicationProperties applicationProperties) {
        this.cached = true;
        this.excludedMimes = this.splitToSet(applicationProperties.getDefaultBackedString("jira.filters.encoding.enforcer.excluded.mimes")).orElse(defaultContentTypes);
        this.virtualDirectories = this.splitToSet(applicationProperties.getDefaultBackedString("jira.filters.encoding.enforcer.excluded.paths")).map(paths -> paths.stream().map(path -> path.startsWith("/") ? path : "/" + path).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    private Optional<Set<String>> splitToSet(String serializedSet) {
        if (Strings.isNullOrEmpty((String)serializedSet)) {
            return Optional.empty();
        }
        return Optional.of(new HashSet<String>(Arrays.asList(serializedSet.split(";"))));
    }
}

