/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.login.LoginManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.interceptor.LoginInterceptor;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JiraLoginInterceptor
implements LoginInterceptor {
    public void beforeLogin(HttpServletRequest request, HttpServletResponse response, String username, String password, boolean cookieLogin) {
    }

    public void afterLogin(HttpServletRequest request, HttpServletResponse response, String username, String password, boolean cookieLogin, String loginStatus) {
        if (!"success".equals(loginStatus)) {
            return;
        }
        UserRole userRole = JiraLoginInterceptor.getUserRole(request);
        if (userRole != null) {
            UserManager userManager = ComponentAccessor.getUserManager();
            GlobalPermissionManager globalPermissionManager = ComponentAccessor.getGlobalPermissionManager();
            LoginManager loginManager = (LoginManager)ComponentAccessor.getComponent(LoginManager.class);
            ApplicationUser currentUser = userManager.getUserByName(username);
            if (userRole.equals((Object)UserRole.SYSADMIN) && !globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, currentUser) || userRole.equals((Object)UserRole.ADMIN) && !globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, currentUser)) {
                loginManager.logout(request, response);
            }
        }
    }

    public void destroy() {
    }

    public void init(Map<String, String> params, SecurityConfig config) {
    }

    public static UserRole getUserRole(HttpServletRequest request) {
        UserRole userRole;
        String requestedUserRole = request.getParameter("user_role");
        if (requestedUserRole != null) {
            try {
                userRole = UserRole.valueOf((String)requestedUserRole);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        } else {
            userRole = null;
        }
        return userRole;
    }
}

