/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.steps.requestcleanup;

import com.atlassian.jira.dashboard.permission.JiraPermissionService;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.web.filters.steps.FilterCallContext;
import com.atlassian.jira.web.filters.steps.FilterStep;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestCleanupStep
implements FilterStep {
    private static final Logger log = LoggerFactory.getLogger(RequestCleanupStep.class);

    @Override
    public FilterCallContext beforeDoFilter(FilterCallContext callContext) {
        JiraThreadLocalUtils.preCall();
        DefaultVelocityRequestContextFactory.cacheVelocityRequestContext(callContext.getHttpServletRequest());
        return callContext;
    }

    @Override
    public FilterCallContext finallyAfterDoFilter(FilterCallContext callContext) {
        JiraPermissionService.setAllowEditingOfDefaultDashboard(true);
        JiraThreadLocalUtils.postCall(org.apache.log4j.Logger.getLogger(RequestCleanupStep.class), () -> this.onOpenTransaction(callContext));
        return callContext;
    }

    private void onOpenTransaction(FilterCallContext callContext) {
        HttpServletRequest httpServletRequest = callContext.getHttpServletRequest();
        log.error("The URL of request that did not clear connection is: " + httpServletRequest.getRequestURL());
        HttpSession session = httpServletRequest.getSession(false);
        if (session != null) {
            log.error("The User of request was: " + session.getAttribute("seraph_defaultauthenticator_user"));
        } else {
            log.error("No session found. Cannot determine user.");
        }
        log.error("Content type:" + httpServletRequest.getContentType());
        Map parameterMap = httpServletRequest.getParameterMap();
        if (parameterMap != null) {
            int j = 1;
            Iterator iterator = parameterMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                log.error("Parameter " + j + " name: " + entry.getKey());
                Object value = entry.getValue();
                if (value != null && value instanceof String[]) {
                    String[] valueArray;
                    for (String s : valueArray = (String[])value) {
                        log.error("Parameter value: " + s);
                    }
                } else {
                    log.error("Parameter value: " + value);
                }
                ++j;
            }
        } else {
            log.error("Request did not have any parameters.");
        }
    }
}

