/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.steps.security.csp;

import com.atlassian.validation.Failure;
import com.atlassian.validation.Success;
import com.atlassian.validation.Validator;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Set;

public class CspSandboxContentDispositionValidator
implements Validator {
    private static final String OPTION_REGEX = "^$|([a-zA-Z]+)((;[a-zA-Z]+)*)";
    private static final Set<String> allowedOptions = ImmutableSet.of((Object)"attachment", (Object)"inline", (Object)"");

    @Override
    public Validator.Result validate(String value) {
        if (!value.matches(OPTION_REGEX)) {
            return new Failure("Bad option formatting, should be 'entry;entry...' without semicolon at the end. Allowed options are 'attachment' and/or 'inline'");
        }
        String[] entries = value.split(";");
        if (!Arrays.stream(entries).allMatch(allowedOptions::contains)) {
            return new Failure("Unknown Content-Disposition clause. Use 'attachment' and/or 'inline'. https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Disposition");
        }
        if (Arrays.stream(entries).distinct().count() != (long)entries.length) {
            return new Failure("List contains duplicates, please remove them.");
        }
        return new Success(value);
    }
}

