/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.steps.security.csp;

import com.atlassian.validation.Failure;
import com.atlassian.validation.Success;
import com.atlassian.validation.Validator;
import java.util.Arrays;

public class CspSandboxContentTypeValidator
implements Validator {
    private static final String RESTRICTED_NAME_FIRST = "[a-zA-Z0-9]";
    private static final String RESTRICTED_NAME_CHARS = "[a-zA-Z0-9!#$&^_.+-]";
    private static final String RESTRICTED_NAME = "[a-zA-Z0-9][a-zA-Z0-9!#$&^_.+-]{0,126}";
    private static final String MIME_TYPE = "[a-zA-Z0-9][a-zA-Z0-9!#$&^_.+-]{0,126}/[a-zA-Z0-9][a-zA-Z0-9!#$&^_.+-]{0,126}";
    private static final String MIME_TYPES_REGEX = "^$|([a-zA-Z0-9][a-zA-Z0-9!#$&^_.+-]{0,126}/[a-zA-Z0-9][a-zA-Z0-9!#$&^_.+-]{0,126})((;[a-zA-Z0-9][a-zA-Z0-9!#$&^_.+-]{0,126}/[a-zA-Z0-9][a-zA-Z0-9!#$&^_.+-]{0,126})*)";

    @Override
    public Validator.Result validate(String value) {
        if (!value.matches(MIME_TYPES_REGEX)) {
            return new Failure("Bad option formatting, should be 'mime/type;mime/type...' without semicolon at the end.'mime/type' should comply with https://tools.ietf.org/html/rfc6838#section-4.2.");
        }
        String[] entries = value.split(";");
        if (Arrays.stream(entries).distinct().count() != (long)entries.length) {
            return new Failure("List contains duplicates, please remove them.");
        }
        return new Success(value);
    }
}

