/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.pagebuilder.strategy.flushappheaderearly;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.servermetrics.RequestCheckpoints;
import com.atlassian.jira.servermetrics.ServerMetricsDetailCollector;
import com.atlassian.jira.web.filters.CommittedResponseHtmlErrorRecoveryFilter;
import com.atlassian.jira.web.pagebuilder.CommonWebResourcesProvider;
import com.atlassian.jira.web.pagebuilder.DecoratablePage;
import com.atlassian.jira.web.pagebuilder.PageBuildingException;
import com.atlassian.jira.web.pagebuilder.PagePartFlusher;
import com.atlassian.jira.web.pagebuilder.strategy.PageBuildingStrategy;
import com.atlassian.jira.web.pagebuilder.strategy.flushappheaderearly.PagePartsFactory;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atlassian.webresource.api.assembler.resource.ResourcePhase;
import com.opensymphony.module.sitemesh.RequestConstants;
import java.io.IOException;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FlushAppHeaderEarlyPageBuildingStrategy
implements PageBuildingStrategy {
    private final ServerMetricsDetailCollector serverMetricsDetailCollector;
    private final ApplicationProperties applicationProperties;
    private final CommonWebResourcesProvider commonWebResourcesProvider;
    private final Supplier<String> titleSupplier;
    private final PagePartsFactory pagePartsFactory;
    private final PageBuilderService pageBuilderService;
    private boolean alreadyFlushed = false;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PagePartFlusher pagePartFlusher;
    private PagePartsFactory.PagePartsWriters writers;

    public FlushAppHeaderEarlyPageBuildingStrategy(ServerMetricsDetailCollector serverMetricsDetailCollector, ApplicationProperties applicationProperties, CommonWebResourcesProvider commonWebResourcesProvider, PagePartsFactory pagePartsFactory, PageBuilderService pageBuilderService, Supplier<String> pageTitleSupplier) {
        this.serverMetricsDetailCollector = serverMetricsDetailCollector;
        this.applicationProperties = applicationProperties;
        this.commonWebResourcesProvider = commonWebResourcesProvider;
        this.pagePartsFactory = pagePartsFactory;
        this.pageBuilderService = pageBuilderService;
        this.titleSupplier = pageTitleSupplier;
    }

    @Override
    public void setUp(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        this.request.setAttribute(CommittedResponseHtmlErrorRecoveryFilter.ENABLE_COMMITTED_RESPONSE_HTML_ERROR_RECOVERY, (Object)Boolean.TRUE);
        this.request.setAttribute(RequestConstants.DISABLE_BUFFER_AND_DECORATION, (Object)true);
        this.pagePartFlusher = new PagePartFlusher(servletContext, request, response);
        try {
            this.writers = this.pagePartsFactory.getPagePartsWriters(response);
        }
        catch (IOException ex) {
            throw new PageBuildingException("Cannot initialize pagePartsProviderFactory", ex);
        }
    }

    @Override
    public void flushEarly() throws IOException {
        if (!this.alreadyFlushed) {
            this.alreadyFlushed = true;
            this.response.setContentType(this.applicationProperties.getContentType());
            this.response.setCharacterEncoding(this.applicationProperties.getEncoding());
            this.disableNginxProxyBuffering();
            this.serverMetricsDetailCollector.checkpointReached(RequestCheckpoints.beforePageBuilderFlushHeadEarly.name());
            this.pageBuilderService.assembler().resources().requireContext(ResourcePhase.INLINE, "flush-app-header-early-inline-resources");
            this.pagePartFlusher.flushPagePart("/decorators/general-flush-early-head-and-header-skeleton.jsp");
            this.serverMetricsDetailCollector.checkpointReached(RequestCheckpoints.afterPageBuilderWriteHead.name());
        }
        this.commonWebResourcesProvider.drainIncludedWebResources(this.response.getWriter());
        this.createSession();
        this.response.getWriter().flush();
    }

    private void disableNginxProxyBuffering() {
        this.response.setHeader("X-Accel-Buffering", "no");
    }

    private void createSession() {
        this.request.getSession(true);
    }

    @Override
    public void finish(DecoratablePage page) throws IOException {
        this.flushEarly();
        this.pagePartFlusher.flushPagePart("/decorators/general-flush-early-real-app-header.jsp");
        this.serverMetricsDetailCollector.checkpointReached(RequestCheckpoints.afterPageBuilderPreBodyDecorator.name());
        this.writers.parsedHead().write(page);
        this.writers.title().write(this.titleSupplier);
        this.writers.bodyClasses().write(page);
        this.writers.bodyAttributes().write();
        page.writeBody(this.response.getWriter());
        this.serverMetricsDetailCollector.checkpointReached(RequestCheckpoints.afterPageBuilderWriteBody.name());
        this.pagePartFlusher.flushPagePart("/decorators/general-body-post.jsp");
    }
}

