/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.pagebuilder.strategy.flushappheaderearly;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.ImmutableMap;
import java.io.PrintWriter;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class TitleWriter {
    private final PrintWriter responseWriter;
    private final SoyTemplateRenderer soyRenderer;
    private final ApplicationProperties applicationProperties;

    public TitleWriter(PrintWriter responseWriter, SoyTemplateRenderer soyRenderer, ApplicationProperties applicationProperties) {
        this.responseWriter = responseWriter;
        this.soyRenderer = soyRenderer;
        this.applicationProperties = applicationProperties;
    }

    public void write(Supplier<String> titleSupplier) {
        if (StringUtils.isNotBlank((String)titleSupplier.get())) {
            this.responseWriter.println(this.soyRenderer.render("jira.webresources:soy-templates", "JIRA.Templates.FlushAppHeaderEarly.titleProvider", (Map)ImmutableMap.of((Object)"title", (Object)this.formatTitle(titleSupplier))));
        }
    }

    private String formatTitle(Supplier<String> titleSupplier) {
        String pageTitle = String.format("%s - %s", titleSupplier.get(), this.applicationProperties.getDefaultBackedString("jira.title"));
        return StringEscapeUtils.escapeJavaScript((String)pageTitle);
    }
}

